/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.mvc.commons.interceptor;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.skywalking.apm.agent.core.context.CarrierItem;
import org.apache.skywalking.apm.agent.core.context.ContextCarrier;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.agent.core.util.CollectionUtil;
import org.apache.skywalking.apm.agent.core.util.MethodUtil;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.apache.skywalking.apm.network.trace.component.ComponentsDefine;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.EnhanceRequireObjectCache;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.RequestHolder;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.ResponseHolder;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.SpringMVCPluginConfig;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.exception.IllegalMethodStackDepthException;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.exception.ServletResponseNotFoundException;
import org.apache.skywalking.apm.plugin.spring.mvc.commons.interceptor.StackDepth;
import org.apache.skywalking.apm.util.StringUtil;

public abstract class AbstractMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static boolean IS_SERVLET_GET_STATUS_METHOD_EXIST = MethodUtil.isMethodExist((ClassLoader)AbstractMethodInterceptor.class.getClassLoader(), (String)"javax.servlet.http.HttpServletResponse", (String)"getStatus", (String[])new String[0]);
    private static final String SERVLET_RESPONSE_CLASS = "javax.servlet.http.HttpServletResponse";
    private static final String GET_STATUS_METHOD = "getStatus";

    public abstract String getRequestURL(Method var1);

    public abstract String getAcceptedMethodTypes(Method var1);

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        String operationName;
        Boolean forwardRequestFlag = (Boolean)ContextManager.getRuntimeContext().get((Object)"SW_FORWARD_REQUEST_FLAG");
        if (forwardRequestFlag != null && forwardRequestFlag.booleanValue()) {
            return;
        }
        if (SpringMVCPluginConfig.Plugin.SpringMVC.USE_QUALIFIED_NAME_AS_ENDPOINT_NAME) {
            operationName = MethodUtil.generateOperationName((Method)method);
        } else {
            EnhanceRequireObjectCache pathMappingCache = (EnhanceRequireObjectCache)objInst.getSkyWalkingDynamicField();
            String requestURL = pathMappingCache.findPathMapping(method);
            if (requestURL == null) {
                requestURL = this.getRequestURL(method);
                pathMappingCache.addPathMapping(method, requestURL);
                requestURL = pathMappingCache.findPathMapping(method);
            }
            operationName = this.getAcceptedMethodTypes(method) + requestURL;
        }
        RequestHolder request = (RequestHolder)ContextManager.getRuntimeContext().get((Object)"SW_REQUEST");
        if (request != null) {
            StackDepth stackDepth = (StackDepth)ContextManager.getRuntimeContext().get((Object)"SW_CONTROLLER_METHOD_STACK_DEPTH");
            if (stackDepth == null) {
                ContextCarrier contextCarrier = new ContextCarrier();
                CarrierItem next = contextCarrier.items();
                while (next.hasNext()) {
                    next = next.next();
                    next.setHeadValue(request.getHeader(next.getHeadKey()));
                }
                AbstractSpan span = ContextManager.createEntrySpan((String)operationName, (ContextCarrier)contextCarrier);
                Tags.URL.set(span, request.requestURL());
                Tags.HTTP.METHOD.set(span, request.requestMethod());
                span.setComponent((Component)ComponentsDefine.SPRING_MVC_ANNOTATION);
                SpanLayer.asHttp((AbstractSpan)span);
                if (SpringMVCPluginConfig.Plugin.SpringMVC.COLLECT_HTTP_PARAMS) {
                    this.collectHttpParam(request, span);
                }
                if (!CollectionUtil.isEmpty(SpringMVCPluginConfig.Plugin.Http.INCLUDE_HTTP_HEADERS)) {
                    this.collectHttpHeaders(request, span);
                }
                stackDepth = new StackDepth();
                ContextManager.getRuntimeContext().put((Object)"SW_CONTROLLER_METHOD_STACK_DEPTH", (Object)stackDepth);
            } else {
                AbstractSpan span = ContextManager.createLocalSpan((String)this.buildOperationName(objInst, method));
                span.setComponent((Component)ComponentsDefine.SPRING_MVC_ANNOTATION);
            }
            stackDepth.increment();
        }
    }

    private String buildOperationName(Object invoker, Method method) {
        StringBuilder operationName = new StringBuilder(invoker.getClass().getName()).append(".").append(method.getName()).append("(");
        for (Class<?> type : method.getParameterTypes()) {
            operationName.append(type.getName()).append(",");
        }
        if (method.getParameterTypes().length > 0) {
            operationName = operationName.deleteCharAt(operationName.length() - 1);
        }
        return operationName.append(")").toString();
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        Boolean forwardRequestFlag = (Boolean)ContextManager.getRuntimeContext().get((Object)"SW_FORWARD_REQUEST_FLAG");
        if (forwardRequestFlag != null && forwardRequestFlag.booleanValue()) {
            return ret;
        }
        RequestHolder request = (RequestHolder)ContextManager.getRuntimeContext().get((Object)"SW_REQUEST");
        if (request != null) {
            StackDepth stackDepth = (StackDepth)ContextManager.getRuntimeContext().get((Object)"SW_CONTROLLER_METHOD_STACK_DEPTH");
            if (stackDepth == null) {
                throw new IllegalMethodStackDepthException();
            }
            stackDepth.decrement();
            AbstractSpan span = ContextManager.activeSpan();
            if (stackDepth.depth() == 0) {
                ResponseHolder response = (ResponseHolder)ContextManager.getRuntimeContext().get((Object)"SW_RESPONSE");
                if (response == null) {
                    throw new ServletResponseNotFoundException();
                }
                if (IS_SERVLET_GET_STATUS_METHOD_EXIST && response.statusCode() >= 400) {
                    span.errorOccurred();
                    Tags.STATUS_CODE.set(span, Integer.toString(response.statusCode()));
                }
                ContextManager.getRuntimeContext().remove((Object)"SW_REQUEST");
                ContextManager.getRuntimeContext().remove((Object)"SW_RESPONSE");
                ContextManager.getRuntimeContext().remove((Object)"SW_CONTROLLER_METHOD_STACK_DEPTH");
            }
            if (!SpringMVCPluginConfig.Plugin.SpringMVC.COLLECT_HTTP_PARAMS && span.isProfiling()) {
                this.collectHttpParam(request, span);
            }
            ContextManager.stopSpan();
        }
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
        ContextManager.activeSpan().log(t);
    }

    private void collectHttpParam(RequestHolder request, AbstractSpan span) {
        Map<String, String[]> parameterMap = request.getParameterMap();
        if (parameterMap != null && !parameterMap.isEmpty()) {
            String tagValue = CollectionUtil.toString(parameterMap);
            tagValue = SpringMVCPluginConfig.Plugin.Http.HTTP_PARAMS_LENGTH_THRESHOLD > 0 ? StringUtil.cut((String)tagValue, (int)SpringMVCPluginConfig.Plugin.Http.HTTP_PARAMS_LENGTH_THRESHOLD) : tagValue;
            Tags.HTTP.PARAMS.set(span, tagValue);
        }
    }

    private void collectHttpHeaders(RequestHolder request, AbstractSpan span) {
        ArrayList headersList = new ArrayList(SpringMVCPluginConfig.Plugin.Http.INCLUDE_HTTP_HEADERS.size());
        SpringMVCPluginConfig.Plugin.Http.INCLUDE_HTTP_HEADERS.stream().filter(headerName -> request.getHeaders((String)headerName) != null).forEach(headerName -> {
            Enumeration<String> headerValues = request.getHeaders((String)headerName);
            ArrayList<String> valueList = Collections.list(headerValues);
            if (!CollectionUtil.isEmpty(valueList)) {
                String headerValue = ((Object)valueList).toString();
                headersList.add(headerName + "=" + headerValue);
            }
        });
        if (!headersList.isEmpty()) {
            String tagValue = headersList.stream().collect(Collectors.joining("\n"));
            tagValue = SpringMVCPluginConfig.Plugin.Http.HTTP_HEADERS_LENGTH_THRESHOLD > 0 ? StringUtil.cut((String)tagValue, (int)SpringMVCPluginConfig.Plugin.Http.HTTP_HEADERS_LENGTH_THRESHOLD) : tagValue;
            Tags.HTTP.HEADERS.set(span, tagValue);
        }
    }
}

