/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.test.tools;

import junit.framework.TestCase;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.context.trace.LogDataEntity;
import org.apache.skywalking.apm.agent.core.context.trace.SpanLayer;
import org.apache.skywalking.apm.agent.core.context.util.KeyValuePair;
import org.apache.skywalking.apm.agent.test.helper.SpanHelper;
import org.apache.skywalking.apm.network.trace.component.Component;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;

public class SpanAssert {
    public static void assertLogSize(AbstractSpan span, int exceptedSize) {
        Assert.assertThat((Object)SpanHelper.getLogs(span).size(), (Matcher)CoreMatchers.is((Object)exceptedSize));
    }

    public static void assertTagSize(AbstractSpan span, int exceptedSize) {
        Assert.assertThat((Object)SpanHelper.getTags(span).size(), (Matcher)CoreMatchers.is((Object)exceptedSize));
    }

    public static void assertException(LogDataEntity logDataEntity, Class<? extends Throwable> throwableClass, String message) {
        Assert.assertThat((Object)logDataEntity.getLogs().size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)((KeyValuePair)logDataEntity.getLogs().get(0)).getValue(), (Matcher)CoreMatchers.is((Object)"error"));
        Assert.assertThat((Object)((KeyValuePair)logDataEntity.getLogs().get(1)).getValue(), (Matcher)CoreMatchers.is((Object)throwableClass.getName()));
        Assert.assertThat((Object)((KeyValuePair)logDataEntity.getLogs().get(2)).getValue(), (Matcher)CoreMatchers.is((Object)message));
        TestCase.assertNotNull((Object)((KeyValuePair)logDataEntity.getLogs().get(3)).getValue());
    }

    public static void assertException(LogDataEntity logDataEntity, Class<? extends Throwable> throwableClass) {
        Assert.assertThat((Object)logDataEntity.getLogs().size(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)((KeyValuePair)logDataEntity.getLogs().get(0)).getValue(), (Matcher)CoreMatchers.is((Object)"error"));
        Assert.assertThat((Object)((KeyValuePair)logDataEntity.getLogs().get(1)).getValue(), (Matcher)CoreMatchers.is((Object)throwableClass.getName()));
        Assert.assertNull((Object)((KeyValuePair)logDataEntity.getLogs().get(2)).getValue());
        TestCase.assertNotNull((Object)((KeyValuePair)logDataEntity.getLogs().get(3)).getValue());
    }

    public static void assertComponent(AbstractSpan span, Component component) {
        Assert.assertThat((Object)SpanHelper.getComponentId(span), (Matcher)CoreMatchers.is((Object)component.getId()));
    }

    public static void assertComponent(AbstractSpan span, String componentName) {
        Assert.assertThat((Object)SpanHelper.getComponentName(span), (Matcher)CoreMatchers.is((Object)componentName));
    }

    public static void assertLayer(AbstractSpan span, SpanLayer spanLayer) {
        Assert.assertThat((Object)SpanHelper.getLayer(span), (Matcher)CoreMatchers.is((Object)spanLayer));
    }

    public static void assertTag(AbstractSpan span, int index, String value) {
        Assert.assertThat((Object)SpanHelper.getTags(span).get(index).getValue(), (Matcher)CoreMatchers.is((Object)value));
    }

    public static void assertOccurException(AbstractSpan span, boolean excepted) {
        Assert.assertThat((Object)SpanHelper.getErrorOccurred(span), (Matcher)CoreMatchers.is((Object)excepted));
    }
}

