/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.agent.test.tools;

import java.lang.reflect.Field;
import org.apache.skywalking.apm.agent.core.context.IgnoreTracerContextListener;
import org.apache.skywalking.apm.agent.core.context.IgnoredTracerContext;
import org.apache.skywalking.apm.agent.core.context.TracingContext;
import org.apache.skywalking.apm.agent.core.context.TracingContextListener;
import org.apache.skywalking.apm.agent.core.context.trace.TraceSegment;
import org.apache.skywalking.apm.agent.test.tools.SegmentStorage;
import org.apache.skywalking.apm.agent.test.tools.SegmentStoragePoint;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class TracingSegmentRunner
extends BlockJUnit4ClassRunner {
    private TracingContextListener tracingContextListener;
    private IgnoreTracerContextListener ignoreTracerContextListener;
    private Field field;
    private Object targetObject;
    private SegmentStorage tracingData;

    public TracingSegmentRunner(Class<?> klass) throws InitializationError {
        super(klass);
        for (Field field : klass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(SegmentStoragePoint.class) || !field.getType().equals(SegmentStorage.class)) continue;
            this.field = field;
            this.field.setAccessible(true);
            break;
        }
    }

    protected Object createTest() throws Exception {
        this.targetObject = super.createTest();
        return this.targetObject;
    }

    protected Statement withAfters(FrameworkMethod method, Object target, final Statement statement) {
        Statement st = new Statement(){

            public void evaluate() throws Throwable {
                if (TracingSegmentRunner.this.field != null) {
                    try {
                        TracingSegmentRunner.this.tracingData = new SegmentStorage();
                        TracingSegmentRunner.this.field.set(TracingSegmentRunner.this.targetObject, TracingSegmentRunner.this.tracingData);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        // empty catch block
                    }
                }
                TracingSegmentRunner.this.tracingContextListener = new TracingContextListener(){

                    public void afterFinished(TraceSegment traceSegment) {
                        TracingSegmentRunner.this.tracingData.addTraceSegment(traceSegment);
                    }
                };
                TracingSegmentRunner.this.ignoreTracerContextListener = new IgnoreTracerContextListener(){

                    public void afterFinished(IgnoredTracerContext tracerContext) {
                        TracingSegmentRunner.this.tracingData.addIgnoreTraceContext(tracerContext);
                    }
                };
                TracingContext.ListenerManager.add((TracingContextListener)TracingSegmentRunner.this.tracingContextListener);
                IgnoredTracerContext.ListenerManager.add((IgnoreTracerContextListener)TracingSegmentRunner.this.ignoreTracerContextListener);
                try {
                    statement.evaluate();
                }
                finally {
                    TracingContext.ListenerManager.remove((TracingContextListener)TracingSegmentRunner.this.tracingContextListener);
                    IgnoredTracerContext.ListenerManager.remove((IgnoreTracerContextListener)TracingSegmentRunner.this.ignoreTracerContextListener);
                }
            }
        };
        return super.withAfters(method, target, st);
    }
}

