/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.toolkit.meter.impl;

import java.util.Objects;
import org.apache.skywalking.apm.toolkit.meter.BaseBuilder;
import org.apache.skywalking.apm.toolkit.meter.BaseMeter;
import org.apache.skywalking.apm.toolkit.meter.MeterId;
import org.apache.skywalking.apm.toolkit.meter.impl.AbstractMeter;
import org.apache.skywalking.apm.toolkit.meter.impl.MeterCenter;

public abstract class AbstractBuilder<BUILDER extends BaseBuilder, BASE extends BaseMeter, IMPL extends AbstractMeter>
implements BaseBuilder<BUILDER, BASE> {
    protected final MeterId meterId;

    public AbstractBuilder(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Meter name cannot be null");
        }
        this.meterId = new MeterId(name, this.getType());
    }

    public AbstractBuilder(MeterId meterId) {
        if (meterId == null) {
            throw new IllegalArgumentException("Meter id cannot be null");
        }
        if (!Objects.equals((Object)meterId.getType(), (Object)this.getType())) {
            throw new IllegalArgumentException("Meter id type is not matches");
        }
        this.meterId = meterId;
    }

    @Override
    public BUILDER tag(String name, String value) {
        this.meterId.getTags().add(new MeterId.Tag(name, value));
        return (BUILDER)this;
    }

    protected abstract BASE create(MeterId var1);

    protected void accept(IMPL meter) throws IllegalArgumentException {
    }

    protected abstract MeterId.MeterType getType();

    public MeterId getMeterId() {
        return this.meterId;
    }

    @Override
    public BASE build() {
        this.meterId.getTags().sort(MeterId.Tag::compareTo);
        return MeterCenter.getOrCreateMeter(this);
    }
}

