/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.toolkit.meter.impl;

import java.util.function.Supplier;
import org.apache.skywalking.apm.toolkit.meter.Gauge;
import org.apache.skywalking.apm.toolkit.meter.MeterId;
import org.apache.skywalking.apm.toolkit.meter.impl.AbstractBuilder;
import org.apache.skywalking.apm.toolkit.meter.impl.AbstractMeter;

public class GaugeImpl
extends AbstractMeter
implements Gauge {
    protected Supplier<Double> getter;

    public GaugeImpl(MeterId meterId, Supplier<Double> getter) {
        super(meterId);
        this.getter = getter;
    }

    @Override
    public double get() {
        return this.getter.get();
    }

    public static class Builder
    extends AbstractBuilder<Gauge.Builder, Gauge, GaugeImpl>
    implements Gauge.Builder {
        private final Supplier<Double> getter;

        public Builder(String name, Supplier<Double> getter) {
            super(name);
            this.getter = getter;
        }

        public Builder(MeterId meterId, Supplier<Double> getter) {
            super(meterId);
            this.getter = getter;
        }

        @Override
        public void accept(GaugeImpl meter) {
            if (this.getter != meter.getter) {
                throw new IllegalArgumentException("Getter is not same");
            }
        }

        @Override
        public GaugeImpl create(MeterId meterId) {
            if (this.getter == null) {
                throw new IllegalArgumentException("getter cannot be null");
            }
            return new GaugeImpl(meterId, this.getter);
        }

        @Override
        public MeterId.MeterType getType() {
            return MeterId.MeterType.GAUGE;
        }
    }
}

