/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.util;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class StringFormatGroup {
    private final List<PatternRule> rules = new ArrayList<PatternRule>();

    public void addRule(String name, String ruleRegex) {
        if (this.rules.contains(name)) {
            return;
        }
        PatternRule rule = new PatternRule(name, ruleRegex);
        this.rules.add(rule);
    }

    public FormatResult format(String string) {
        for (PatternRule rule : this.rules) {
            if (!rule.getPattern().matcher(string).matches()) continue;
            return new FormatResult(true, rule.getName());
        }
        return new FormatResult(false, string);
    }

    public String toString() {
        return "StringFormatGroup{rules=" + this.rules + '}';
    }

    private class PatternRule {
        private String name;
        private Pattern pattern;

        private PatternRule(String name, String ruleRegex) {
            this.name = name;
            this.pattern = Pattern.compile(ruleRegex);
        }

        public String getName() {
            return this.name;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public String toString() {
            return "PatternRule{name='" + this.name + '\'' + ", pattern=" + this.pattern + '}';
        }
    }

    public class FormatResult {
        private boolean match;
        private String name;

        public FormatResult(boolean match, String name) {
            this.match = match;
            this.name = name;
        }

        public boolean isMatch() {
            return this.match;
        }

        public String getName() {
            return this.name;
        }
    }
}

