/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.webflux.v5;

import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.ContextManager;
import org.apache.skywalking.apm.agent.core.context.tag.Tags;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.spring.webflux.v5.DispatcherHandlerHandleMethodInterceptor;
import org.springframework.http.HttpStatus;
import org.springframework.web.server.ServerWebExchange;

public class AbstractServerResponseMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String ERROR_ATTRIBUTE = "org.springframework.boot.web.reactive.error.DefaultErrorAttributes.ERROR";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        EnhancedInstance instance = DispatcherHandlerHandleMethodInterceptor.getInstance(allArguments[0]);
        if (instance != null) {
            AbstractSpan span = (AbstractSpan)instance.getSkyWalkingDynamicField();
            if (span == null) {
                return;
            }
            ServerWebExchange exchange = (ServerWebExchange)allArguments[0];
            HttpStatus status = exchange.getResponse().getStatusCode();
            if (status != null && status.value() >= 400) {
                span.errorOccurred();
                if (exchange.getAttribute(ERROR_ATTRIBUTE) != null) {
                    span.log((Throwable)exchange.getAttribute(ERROR_ATTRIBUTE));
                }
                Tags.STATUS_CODE.set(span, Integer.toString(status.value()));
            }
            if (ContextManager.isActive()) {
                ContextManager.stopSpan((AbstractSpan)span);
            } else {
                span.asyncFinish();
            }
            ((EnhancedInstance)allArguments[0]).setSkyWalkingDynamicField(null);
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }
}

