/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.apm.plugin.spring.webflux.v5;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.apache.skywalking.apm.agent.core.context.trace.AbstractSpan;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.EnhancedInstance;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.InstanceMethodsAroundInterceptor;
import org.apache.skywalking.apm.agent.core.plugin.interceptor.enhance.MethodInterceptResult;
import org.apache.skywalking.apm.plugin.spring.webflux.v5.DispatcherHandlerHandleMethodInterceptor;
import org.springframework.web.method.HandlerMethod;

public class DispatcherHandlerInvokeHandlerMethodInterceptor
implements InstanceMethodsAroundInterceptor {
    private static final String ROUTER_SEARCH = "$$Lambda";
    private static final String ROUTER_FIELD = "arg$1";
    private static final String DOT = ".";

    public void beforeMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, MethodInterceptResult result) throws Throwable {
        EnhancedInstance instance = DispatcherHandlerHandleMethodInterceptor.getInstance(allArguments[0]);
        if (instance != null) {
            AbstractSpan span = (AbstractSpan)instance.getSkyWalkingDynamicField();
            if (span == null) {
                return;
            }
            String handleClassName = allArguments[1].getClass().getSimpleName();
            int index = handleClassName.indexOf(ROUTER_SEARCH);
            if (index != -1) {
                String operationName = handleClassName.substring(0, index);
                try {
                    Field field = allArguments[1].getClass().getDeclaredField(ROUTER_FIELD);
                    field.setAccessible(true);
                    operationName = operationName + DOT + field.get(allArguments[1]).getClass().getName();
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
                span.setOperationName(operationName);
            } else if (allArguments[1] instanceof HandlerMethod) {
                HandlerMethod handler = (HandlerMethod)allArguments[1];
                span.setOperationName(this.getHandlerMethodOperationName(handler));
            }
        }
    }

    public Object afterMethod(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Object ret) throws Throwable {
        return ret;
    }

    public void handleMethodException(EnhancedInstance objInst, Method method, Object[] allArguments, Class<?>[] argumentsTypes, Throwable t) {
    }

    private String getHandlerMethodOperationName(HandlerMethod handler) {
        Method method = handler.getMethod();
        return method.getDeclaringClass().getName() + DOT + method.getName();
    }
}

