/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.stream.v1;

import com.google.protobuf.GeneratedMessageV3;
import io.envoyproxy.pgv.RepeatedValidation;
import io.envoyproxy.pgv.RequiredValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import org.apache.skywalking.banyandb.stream.v1.BanyandbStream;

public class BanyandbStreamValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(BanyandbStream.Element.class)) {
            return new ElementValidator();
        }
        if (clazz.equals(BanyandbStream.QueryResponse.class)) {
            return new QueryResponseValidator();
        }
        if (clazz.equals(BanyandbStream.QueryRequest.class)) {
            return new QueryRequestValidator();
        }
        if (clazz.equals(BanyandbStream.ElementValue.class)) {
            return new ElementValueValidator();
        }
        if (clazz.equals(BanyandbStream.WriteRequest.class)) {
            return new WriteRequestValidator();
        }
        if (clazz.equals(BanyandbStream.WriteResponse.class)) {
            return new WriteResponseValidator();
        }
        return null;
    }

    public static class WriteResponseValidator
    implements ValidatorImpl<BanyandbStream.WriteResponse> {
        public void assertValid(BanyandbStream.WriteResponse proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class WriteRequestValidator
    implements ValidatorImpl<BanyandbStream.WriteRequest> {
        public void assertValid(BanyandbStream.WriteRequest proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasMetadata()) {
                RequiredValidation.required((String)".banyandb.stream.v1.WriteRequest.metadata", (GeneratedMessageV3)proto.getMetadata());
            } else {
                RequiredValidation.required((String)".banyandb.stream.v1.WriteRequest.metadata", null);
            }
            if (proto.hasMetadata()) {
                index.validatorFor((Object)proto.getMetadata()).assertValid((Object)proto.getMetadata());
            }
            if (proto.hasElement()) {
                RequiredValidation.required((String)".banyandb.stream.v1.WriteRequest.element", (GeneratedMessageV3)proto.getElement());
            } else {
                RequiredValidation.required((String)".banyandb.stream.v1.WriteRequest.element", null);
            }
            if (proto.hasElement()) {
                index.validatorFor((Object)proto.getElement()).assertValid((Object)proto.getElement());
            }
        }
    }

    public static class ElementValueValidator
    implements ValidatorImpl<BanyandbStream.ElementValue> {
        public void assertValid(BanyandbStream.ElementValue proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasTimestamp()) {
                index.validatorFor((Object)proto.getTimestamp()).assertValid((Object)proto.getTimestamp());
            }
            RepeatedValidation.forEach(proto.getTagFamiliesList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class QueryRequestValidator
    implements ValidatorImpl<BanyandbStream.QueryRequest> {
        public void assertValid(BanyandbStream.QueryRequest proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasMetadata()) {
                RequiredValidation.required((String)".banyandb.stream.v1.QueryRequest.metadata", (GeneratedMessageV3)proto.getMetadata());
            } else {
                RequiredValidation.required((String)".banyandb.stream.v1.QueryRequest.metadata", null);
            }
            if (proto.hasMetadata()) {
                index.validatorFor((Object)proto.getMetadata()).assertValid((Object)proto.getMetadata());
            }
            if (proto.hasTimeRange()) {
                index.validatorFor((Object)proto.getTimeRange()).assertValid((Object)proto.getTimeRange());
            }
            if (proto.hasOrderBy()) {
                index.validatorFor((Object)proto.getOrderBy()).assertValid((Object)proto.getOrderBy());
            }
            if (proto.hasCriteria()) {
                index.validatorFor((Object)proto.getCriteria()).assertValid((Object)proto.getCriteria());
            }
            if (proto.hasProjection()) {
                RequiredValidation.required((String)".banyandb.stream.v1.QueryRequest.projection", (GeneratedMessageV3)proto.getProjection());
            } else {
                RequiredValidation.required((String)".banyandb.stream.v1.QueryRequest.projection", null);
            }
            if (proto.hasProjection()) {
                index.validatorFor((Object)proto.getProjection()).assertValid((Object)proto.getProjection());
            }
        }
    }

    public static class QueryResponseValidator
    implements ValidatorImpl<BanyandbStream.QueryResponse> {
        public void assertValid(BanyandbStream.QueryResponse proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getElementsList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class ElementValidator
    implements ValidatorImpl<BanyandbStream.Element> {
        public void assertValid(BanyandbStream.Element proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasTimestamp()) {
                index.validatorFor((Object)proto.getTimestamp()).assertValid((Object)proto.getTimestamp());
            }
            RepeatedValidation.forEach(proto.getTagFamiliesList(), item -> index.validatorFor(item).assertValid(item));
        }
    }
}

