/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.skywalking.banyandb.measure.v1.BanyandbMeasure;
import org.apache.skywalking.banyandb.measure.v1.MeasureServiceGrpc;
import org.apache.skywalking.banyandb.stream.v1.BanyandbStream;
import org.apache.skywalking.banyandb.stream.v1.StreamServiceGrpc;
import org.apache.skywalking.banyandb.v1.client.MeasureBulkWriteProcessor;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.Options;
import org.apache.skywalking.banyandb.v1.client.StreamBulkWriteProcessor;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.banyandb.v1.client.StreamWrite;
import org.apache.skywalking.banyandb.v1.client.grpc.HandleExceptionsWith;
import org.apache.skywalking.banyandb.v1.client.grpc.channel.ChannelManager;
import org.apache.skywalking.banyandb.v1.client.grpc.channel.DefaultChannelFactory;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.Group;
import org.apache.skywalking.banyandb.v1.client.metadata.GroupMetadataRegistry;
import org.apache.skywalking.banyandb.v1.client.metadata.IndexRule;
import org.apache.skywalking.banyandb.v1.client.metadata.IndexRuleBinding;
import org.apache.skywalking.banyandb.v1.client.metadata.IndexRuleBindingMetadataRegistry;
import org.apache.skywalking.banyandb.v1.client.metadata.IndexRuleMetadataRegistry;
import org.apache.skywalking.banyandb.v1.client.metadata.Measure;
import org.apache.skywalking.banyandb.v1.client.metadata.MeasureMetadataRegistry;
import org.apache.skywalking.banyandb.v1.client.metadata.MetadataCache;
import org.apache.skywalking.banyandb.v1.client.metadata.NamedSchema;
import org.apache.skywalking.banyandb.v1.client.metadata.Property;
import org.apache.skywalking.banyandb.v1.client.metadata.PropertyStore;
import org.apache.skywalking.banyandb.v1.client.metadata.ResourceExist;
import org.apache.skywalking.banyandb.v1.client.metadata.Stream;
import org.apache.skywalking.banyandb.v1.client.metadata.StreamMetadataRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(BanyanDBClient.class);
    private final String host;
    private final int port;
    private final Options options;
    private volatile Channel channel;
    private StreamServiceGrpc.StreamServiceStub streamServiceStub;
    private MeasureServiceGrpc.MeasureServiceStub measureServiceStub;
    private StreamServiceGrpc.StreamServiceBlockingStub streamServiceBlockingStub;
    private MeasureServiceGrpc.MeasureServiceBlockingStub measureServiceBlockingStub;
    private volatile boolean isConnected = false;
    private final ReentrantLock connectionEstablishLock;

    public BanyanDBClient(String host, int port) {
        this(host, port, new Options());
    }

    public BanyanDBClient(String host, int port, Options options) {
        this.host = host;
        this.port = port;
        this.options = options;
        this.connectionEstablishLock = new ReentrantLock();
    }

    public void connect() throws IOException {
        this.connectionEstablishLock.lock();
        try {
            if (!this.isConnected) {
                this.channel = ChannelManager.create(this.options.buildChannelManagerSettings(), new DefaultChannelFactory(this.host, this.port, this.options));
                this.streamServiceBlockingStub = StreamServiceGrpc.newBlockingStub(this.channel);
                this.measureServiceBlockingStub = MeasureServiceGrpc.newBlockingStub(this.channel);
                this.streamServiceStub = StreamServiceGrpc.newStub(this.channel);
                this.measureServiceStub = MeasureServiceGrpc.newStub(this.channel);
                this.isConnected = true;
            }
        }
        finally {
            this.connectionEstablishLock.unlock();
        }
    }

    @VisibleForTesting
    void connect(Channel channel) {
        this.connectionEstablishLock.lock();
        try {
            if (!this.isConnected) {
                this.channel = channel;
                this.streamServiceBlockingStub = StreamServiceGrpc.newBlockingStub(this.channel);
                this.measureServiceBlockingStub = MeasureServiceGrpc.newBlockingStub(this.channel);
                this.streamServiceStub = StreamServiceGrpc.newStub(this.channel);
                this.measureServiceStub = MeasureServiceGrpc.newStub(this.channel);
                this.isConnected = true;
            }
        }
        finally {
            this.connectionEstablishLock.unlock();
        }
    }

    public void write(StreamWrite streamWrite) {
        Preconditions.checkState((this.streamServiceStub != null ? 1 : 0) != 0, (Object)"stream service is null");
        StreamObserver<BanyandbStream.WriteRequest> writeRequestStreamObserver = ((StreamServiceGrpc.StreamServiceStub)this.streamServiceStub.withDeadlineAfter(this.getOptions().getDeadline(), TimeUnit.SECONDS)).write(new StreamObserver<BanyandbStream.WriteResponse>(){

            public void onNext(BanyandbStream.WriteResponse writeResponse) {
            }

            public void onError(Throwable throwable) {
                log.error("Error occurs in flushing streams.", throwable);
            }

            public void onCompleted() {
            }
        });
        try {
            writeRequestStreamObserver.onNext((Object)((BanyandbStream.WriteRequest)streamWrite.build()));
        }
        finally {
            writeRequestStreamObserver.onCompleted();
        }
    }

    public StreamBulkWriteProcessor buildStreamWriteProcessor(int maxBulkSize, int flushInterval, int concurrency) {
        Preconditions.checkState((this.streamServiceStub != null ? 1 : 0) != 0, (Object)"stream service is null");
        return new StreamBulkWriteProcessor(this.streamServiceStub, maxBulkSize, flushInterval, concurrency);
    }

    public MeasureBulkWriteProcessor buildMeasureWriteProcessor(int maxBulkSize, int flushInterval, int concurrency) {
        Preconditions.checkState((this.measureServiceStub != null ? 1 : 0) != 0, (Object)"measure service is null");
        return new MeasureBulkWriteProcessor(this.measureServiceStub, maxBulkSize, flushInterval, concurrency);
    }

    public StreamQueryResponse query(StreamQuery streamQuery) throws BanyanDBException {
        Preconditions.checkState((this.streamServiceStub != null ? 1 : 0) != 0, (Object)"stream service is null");
        BanyandbStream.QueryResponse response = HandleExceptionsWith.callAndTranslateApiException(() -> ((StreamServiceGrpc.StreamServiceBlockingStub)this.streamServiceBlockingStub.withDeadlineAfter(this.getOptions().getDeadline(), TimeUnit.SECONDS)).query(streamQuery.build()));
        return new StreamQueryResponse(response);
    }

    public MeasureQueryResponse query(MeasureQuery measureQuery) throws BanyanDBException {
        Preconditions.checkState((this.streamServiceStub != null ? 1 : 0) != 0, (Object)"measure service is null");
        BanyandbMeasure.QueryResponse response = HandleExceptionsWith.callAndTranslateApiException(() -> ((MeasureServiceGrpc.MeasureServiceBlockingStub)this.measureServiceBlockingStub.withDeadlineAfter(this.getOptions().getDeadline(), TimeUnit.SECONDS)).query(measureQuery.build()));
        return new MeasureQueryResponse(response);
    }

    public Group define(Group group) throws BanyanDBException {
        GroupMetadataRegistry registry = new GroupMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.create(group);
        return registry.get(null, group.name());
    }

    public void define(Stream stream) throws BanyanDBException {
        StreamMetadataRegistry streamRegistry = new StreamMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        streamRegistry.create(stream);
        this.defineIndexRules(stream, (List<IndexRule>)stream.indexRules());
        MetadataCache.INSTANCE.register(stream);
    }

    public void define(Measure measure) throws BanyanDBException {
        MeasureMetadataRegistry measureRegistry = new MeasureMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        measureRegistry.create(measure);
        this.defineIndexRules(measure, (List<IndexRule>)measure.indexRules());
        MetadataCache.INSTANCE.register(measure);
    }

    public PropertyStore.ApplyResult apply(Property property) throws BanyanDBException {
        PropertyStore store = new PropertyStore((Channel)Preconditions.checkNotNull((Object)this.channel));
        return store.apply(property);
    }

    public PropertyStore.ApplyResult apply(Property property, PropertyStore.Strategy strategy) throws BanyanDBException {
        PropertyStore store = new PropertyStore((Channel)Preconditions.checkNotNull((Object)this.channel));
        return store.apply(property, strategy);
    }

    public Property findProperty(String group, String name, String id, String ... tags) throws BanyanDBException {
        PropertyStore store = new PropertyStore((Channel)Preconditions.checkNotNull((Object)this.channel));
        return store.get(group, name, id, tags);
    }

    public List<Property> findProperties(String group, String name) throws BanyanDBException {
        PropertyStore store = new PropertyStore((Channel)Preconditions.checkNotNull((Object)this.channel));
        return store.list(group, name);
    }

    public PropertyStore.DeleteResult deleteProperty(String group, String name, String id, String ... tags) throws BanyanDBException {
        PropertyStore store = new PropertyStore((Channel)Preconditions.checkNotNull((Object)this.channel));
        return store.delete(group, name, id, tags);
    }

    private void defineIndexRules(Stream stream, List<IndexRule> indexRules) throws BanyanDBException {
        Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (Object)"measure cannot be null");
        IndexRuleMetadataRegistry irRegistry = new IndexRuleMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        for (IndexRule ir : indexRules) {
            try {
                irRegistry.create(ir);
            }
            catch (BanyanDBException ex) {
                if (ex.getStatus().equals((Object)Status.Code.ALREADY_EXISTS)) continue;
                throw ex;
            }
        }
        if (indexRules.isEmpty()) {
            return;
        }
        List<String> indexRuleNames = indexRules.stream().map(NamedSchema::name).collect(Collectors.toList());
        IndexRuleBindingMetadataRegistry irbRegistry = new IndexRuleBindingMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        IndexRuleBinding binding = IndexRuleBinding.create(stream.group(), IndexRuleBinding.defaultBindingRule(stream.name()), IndexRuleBinding.Subject.referToStream(stream.name()), indexRuleNames);
        irbRegistry.create(binding);
    }

    private void defineIndexRules(Measure measure, List<IndexRule> indexRules) throws BanyanDBException {
        Preconditions.checkArgument((measure != null ? 1 : 0) != 0, (Object)"measure cannot be null");
        IndexRuleMetadataRegistry irRegistry = new IndexRuleMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        for (IndexRule ir : indexRules) {
            try {
                irRegistry.create(ir);
            }
            catch (BanyanDBException ex) {
                if (ex.getStatus().equals((Object)Status.Code.ALREADY_EXISTS)) continue;
                throw ex;
            }
        }
        if (indexRules.isEmpty()) {
            return;
        }
        List<String> indexRuleNames = indexRules.stream().map(NamedSchema::name).collect(Collectors.toList());
        IndexRuleBindingMetadataRegistry irbRegistry = new IndexRuleBindingMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        IndexRuleBinding binding = IndexRuleBinding.create(measure.group(), IndexRuleBinding.defaultBindingRule(measure.name()), IndexRuleBinding.Subject.referToMeasure(measure.name()), indexRuleNames);
        irbRegistry.create(binding);
    }

    public Group findGroup(String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        try {
            return new GroupMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).get(name, name);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                return null;
            }
            throw ex;
        }
    }

    public Stream findStream(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        Stream s = new StreamMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).get(group, name);
        s = s.withIndexRules(this.findIndexRulesByGroupAndBindingName(group, IndexRuleBinding.defaultBindingRule(name)));
        MetadataCache.INSTANCE.register(s);
        return s;
    }

    public Measure findMeasure(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        Measure m = new MeasureMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).get(group, name);
        m = m.withIndexRules(this.findIndexRulesByGroupAndBindingName(group, IndexRuleBinding.defaultBindingRule(name)));
        MetadataCache.INSTANCE.register(m);
        return m;
    }

    private List<IndexRule> findIndexRulesByGroupAndBindingName(String group, String bindingName) throws BanyanDBException {
        IndexRuleBinding irb;
        IndexRuleBindingMetadataRegistry irbRegistry = new IndexRuleBindingMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        try {
            irb = irbRegistry.get(group, bindingName);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                return Collections.emptyList();
            }
            throw ex;
        }
        if (irb == null) {
            return Collections.emptyList();
        }
        IndexRuleMetadataRegistry irRegistry = new IndexRuleMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        ArrayList<IndexRule> indexRules = new ArrayList<IndexRule>(irb.rules().size());
        for (String rule : irb.rules()) {
            try {
                indexRules.add(irRegistry.get(group, rule));
            }
            catch (BanyanDBException ex) {
                if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) continue;
                throw ex;
            }
        }
        return indexRules;
    }

    public ResourceExist existStream(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new StreamMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).exist(group, name);
    }

    public ResourceExist existMeasure(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new MeasureMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).exist(group, name);
    }

    @Override
    public void close() throws IOException {
        this.connectionEstablishLock.lock();
        if (!(this.channel instanceof ManagedChannel)) {
            return;
        }
        ManagedChannel managedChannel = (ManagedChannel)this.channel;
        try {
            if (this.isConnected) {
                managedChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
                this.isConnected = false;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            log.warn("fail to wait for channel termination, shutdown now!", (Throwable)interruptedException);
            managedChannel.shutdownNow();
            this.isConnected = false;
        }
        finally {
            this.connectionEstablishLock.unlock();
        }
    }

    Options getOptions() {
        return this.options;
    }

    Channel getChannel() {
        return this.channel;
    }

    StreamServiceGrpc.StreamServiceStub getStreamServiceStub() {
        return this.streamServiceStub;
    }

    MeasureServiceGrpc.MeasureServiceStub getMeasureServiceStub() {
        return this.measureServiceStub;
    }

    StreamServiceGrpc.StreamServiceBlockingStub getStreamServiceBlockingStub() {
        return this.streamServiceBlockingStub;
    }

    MeasureServiceGrpc.MeasureServiceBlockingStub getMeasureServiceBlockingStub() {
        return this.measureServiceBlockingStub;
    }
}

