/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.skywalking.banyandb.measure.v1.BanyandbMeasure;
import org.apache.skywalking.banyandb.measure.v1.MeasureServiceGrpc;
import org.apache.skywalking.banyandb.v1.client.AbstractBulkWriteProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class MeasureBulkWriteProcessor
extends AbstractBulkWriteProcessor<BanyandbMeasure.WriteRequest, MeasureServiceGrpc.MeasureServiceStub> {
    private static final Logger log = LoggerFactory.getLogger(MeasureBulkWriteProcessor.class);

    protected MeasureBulkWriteProcessor(MeasureServiceGrpc.MeasureServiceStub measureServiceStub, int maxBulkSize, int flushInterval, int concurrency) {
        super(measureServiceStub, "MeasureBulkWriteProcessor", maxBulkSize, flushInterval, concurrency);
    }

    @Override
    protected StreamObserver<BanyandbMeasure.WriteRequest> buildStreamObserver(MeasureServiceGrpc.MeasureServiceStub stub, final CompletableFuture<Void> batch) {
        return stub.write(new StreamObserver<BanyandbMeasure.WriteResponse>(){

            public void onNext(BanyandbMeasure.WriteResponse writeResponse) {
            }

            public void onError(Throwable t) {
                batch.completeExceptionally(t);
                log.error("Error occurs in flushing measures", t);
            }

            public void onCompleted() {
                batch.complete(null);
            }
        });
    }
}

