/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.grpc.channel;

import com.google.common.base.Strings;
import io.grpc.ManagedChannel;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.NegotiationType;
import io.grpc.netty.NettyChannelBuilder;
import io.netty.handler.ssl.SslContextBuilder;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.skywalking.banyandb.v1.client.Options;
import org.apache.skywalking.banyandb.v1.client.grpc.channel.ChannelFactory;
import org.apache.skywalking.banyandb.v1.client.util.PrivateKeyUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultChannelFactory
implements ChannelFactory {
    private static final Logger log = LoggerFactory.getLogger(DefaultChannelFactory.class);
    private final String host;
    private final int port;
    private final Options options;

    @Override
    public ManagedChannel create() throws IOException {
        boolean isCAFileExist;
        NettyChannelBuilder managedChannelBuilder = NettyChannelBuilder.forAddress((String)this.host, (int)this.port).maxInboundMessageSize(this.options.getMaxInboundMessageSize()).usePlaintext();
        File caFile = new File(this.options.getSslTrustCAPath());
        boolean bl = isCAFileExist = caFile.exists() && caFile.isFile();
        if (this.options.isForceTLS() || isCAFileExist) {
            SslContextBuilder builder = GrpcSslContexts.forClient();
            if (isCAFileExist) {
                block16: {
                    String certPath = this.options.getSslCertChainPath();
                    String keyPath = this.options.getSslKeyPath();
                    if (!Strings.isNullOrEmpty((String)certPath) && Strings.isNullOrEmpty((String)keyPath)) {
                        File keyFile = new File(keyPath);
                        File certFile = new File(certPath);
                        if (certFile.isFile() && keyFile.isFile()) {
                            try (FileInputStream cert = new FileInputStream(certFile);
                                 InputStream key = PrivateKeyUtil.loadDecryptionKey(keyFile.getAbsolutePath());){
                                builder.keyManager((InputStream)cert, key);
                                break block16;
                            }
                        }
                        if (!certFile.isFile() || !keyFile.isFile()) {
                            log.warn("Failed to enable mTLS caused by cert or key cannot be found.");
                        }
                    }
                }
                builder.trustManager(caFile);
            }
            managedChannelBuilder.negotiationType(NegotiationType.TLS).sslContext(builder.build());
        }
        return managedChannelBuilder.build();
    }

    public DefaultChannelFactory(String host, int port, Options options) {
        this.host = host;
        this.port = port;
        this.options = options;
    }
}

