/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.List;
import java.util.Set;
import org.apache.skywalking.banyandb.measure.v1.BanyandbMeasure;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.v1.client.AbstractQuery;
import org.apache.skywalking.banyandb.v1.client.PairQueryCondition;
import org.apache.skywalking.banyandb.v1.client.TimestampRange;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.metadata.MetadataCache;

public class MeasureQuery
extends AbstractQuery<BanyandbMeasure.QueryRequest> {
    private final Set<String> fieldProjections;
    private Aggregation aggregation;
    private TopN topN;
    private Integer limit;
    private int offset;
    private AbstractQuery.OrderBy orderBy;

    public MeasureQuery(List<String> groups, String name, Set<String> tagProjections, Set<String> fieldProjections) {
        this(groups, name, null, tagProjections, fieldProjections);
    }

    public MeasureQuery(List<String> groups, String name, TimestampRange timestampRange, Set<String> tagProjections, Set<String> fieldProjections) {
        super(groups, name, timestampRange, tagProjections);
        this.fieldProjections = fieldProjections;
    }

    public MeasureQuery and(PairQueryCondition<?> condition) {
        return (MeasureQuery)super.and(condition);
    }

    public MeasureQuery or(PairQueryCondition<?> condition) {
        return (MeasureQuery)super.or(condition);
    }

    public MeasureQuery groupBy(Set<String> groupByKeys) {
        Preconditions.checkArgument((boolean)this.tagProjections.containsAll(groupByKeys), (Object)"groupBy tags should be selected first");
        this.aggregation = new Aggregation(null, Aggregation.Type.UNSPECIFIED, groupByKeys);
        return this;
    }

    public MeasureQuery maxBy(String field, Set<String> groupByKeys) {
        Preconditions.checkArgument((boolean)this.fieldProjections.contains(field), (Object)"field should be selected first");
        Preconditions.checkArgument((boolean)this.tagProjections.containsAll(groupByKeys), (Object)"groupBy tags should be selected first");
        this.aggregation = new Aggregation(field, Aggregation.Type.MAX, groupByKeys);
        return this;
    }

    public MeasureQuery minBy(String field, Set<String> groupByKeys) {
        Preconditions.checkArgument((boolean)this.fieldProjections.contains(field), (Object)"field should be selected first");
        Preconditions.checkArgument((boolean)this.tagProjections.containsAll(groupByKeys), (Object)"groupBy tags should be selected first");
        Preconditions.checkState((this.aggregation == null ? 1 : 0) != 0, (Object)"aggregation should only be set once");
        this.aggregation = new Aggregation(field, Aggregation.Type.MIN, groupByKeys);
        return this;
    }

    public MeasureQuery meanBy(String field, Set<String> groupByKeys) {
        Preconditions.checkArgument((boolean)this.fieldProjections.contains(field), (Object)"field should be selected first");
        Preconditions.checkArgument((boolean)this.tagProjections.containsAll(groupByKeys), (Object)"groupBy tags should be selected first");
        Preconditions.checkState((this.aggregation == null ? 1 : 0) != 0, (Object)"aggregation should only be set once");
        this.aggregation = new Aggregation(field, Aggregation.Type.MEAN, groupByKeys);
        return this;
    }

    public MeasureQuery countBy(String field, Set<String> groupByKeys) {
        Preconditions.checkArgument((boolean)this.fieldProjections.contains(field), (Object)"field should be selected first");
        Preconditions.checkArgument((boolean)this.tagProjections.containsAll(groupByKeys), (Object)"groupBy tags should be selected first");
        Preconditions.checkState((this.aggregation == null ? 1 : 0) != 0, (Object)"aggregation should only be set once");
        this.aggregation = new Aggregation(field, Aggregation.Type.COUNT, groupByKeys);
        return this;
    }

    public MeasureQuery sumBy(String field, Set<String> groupByKeys) {
        Preconditions.checkArgument((boolean)this.fieldProjections.contains(field), (Object)"field should be selected first");
        Preconditions.checkArgument((boolean)this.tagProjections.containsAll(groupByKeys), (Object)"groupBy tags should be selected first");
        Preconditions.checkState((this.aggregation == null ? 1 : 0) != 0, (Object)"aggregation should only be set once");
        this.aggregation = new Aggregation(field, Aggregation.Type.SUM, groupByKeys);
        return this;
    }

    public MeasureQuery topN(int number, String field) {
        Preconditions.checkArgument((boolean)this.fieldProjections.contains(field), (Object)"field should be selected first");
        this.topN = new TopN(field, number, AbstractQuery.Sort.DESC);
        return this;
    }

    public MeasureQuery bottomN(int number, String field) {
        Preconditions.checkArgument((boolean)this.fieldProjections.contains(field), (Object)"field should be selected first");
        this.topN = new TopN(field, number, AbstractQuery.Sort.ASC);
        return this;
    }

    public MeasureQuery limit(int limit) {
        this.limit = limit;
        return this;
    }

    public MeasureQuery offset(int offset) {
        this.offset = offset;
        return this;
    }

    public MeasureQuery orderBy(String tagName, AbstractQuery.Sort sort) {
        this.orderBy = new AbstractQuery.OrderBy(tagName, sort);
        return this;
    }

    @Override
    BanyandbMeasure.QueryRequest build(MetadataCache.EntityMetadata entityMetadata) throws BanyanDBException {
        if (entityMetadata == null) {
            throw new IllegalArgumentException("entity metadata is null");
        }
        BanyandbMeasure.QueryRequest.Builder builder = BanyandbMeasure.QueryRequest.newBuilder();
        builder.setName(this.name);
        builder.addAllGroups(this.groups);
        if (this.timestampRange != null) {
            builder.setTimeRange(this.timestampRange.build());
        } else {
            builder.setTimeRange(TimestampRange.MAX_RANGE);
        }
        BanyandbModel.TagProjection tagProjections = this.buildTagProjections(entityMetadata);
        if (tagProjections.getTagFamiliesCount() > 0) {
            builder.setTagProjection(this.buildTagProjections(entityMetadata));
        }
        if (!this.fieldProjections.isEmpty()) {
            builder.setFieldProjection(BanyandbMeasure.QueryRequest.FieldProjection.newBuilder().addAllNames(this.fieldProjections).build());
        }
        if (this.aggregation != null) {
            BanyandbMeasure.QueryRequest.GroupBy.Builder groupByBuilder = BanyandbMeasure.QueryRequest.GroupBy.newBuilder().setTagProjection(this.buildTagProjections(entityMetadata, this.aggregation.groupByTagsProjection));
            if (Strings.isNullOrEmpty((String)this.aggregation.fieldName)) {
                if (this.aggregation.aggregationType != Aggregation.Type.UNSPECIFIED) {
                    throw new IllegalArgumentException("field name cannot be null or empty if aggregation is specified");
                }
            } else {
                builder.setGroupBy(groupByBuilder.build());
                groupByBuilder.setFieldName(this.aggregation.fieldName);
                BanyandbMeasure.QueryRequest.Aggregation aggr = BanyandbMeasure.QueryRequest.Aggregation.newBuilder().setFunction(((Aggregation)this.aggregation).aggregationType.function).setFieldName(this.aggregation.fieldName).build();
                builder.setGroupBy(groupByBuilder.build()).setAgg(aggr);
            }
        }
        if (this.topN != null) {
            BanyandbMeasure.QueryRequest.Top top = BanyandbMeasure.QueryRequest.Top.newBuilder().setFieldName(this.topN.fieldName).setNumber(this.topN.number).setFieldValueSort(AbstractQuery.Sort.DESC.equals((Object)this.topN.sort) ? BanyandbModel.Sort.SORT_DESC : BanyandbModel.Sort.SORT_ASC).build();
            builder.setTop(top);
        }
        builder.setOffset(this.offset);
        if (this.limit != null) {
            builder.setLimit(this.limit);
        }
        if (this.orderBy != null) {
            builder.setOrderBy(this.orderBy.build());
        }
        this.buildCriteria().ifPresent(builder::setCriteria);
        builder.setTrace(this.trace);
        return builder.build();
    }

    public void setAggregation(Aggregation aggregation) {
        this.aggregation = aggregation;
    }

    public void setTopN(TopN topN) {
        this.topN = topN;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setOrderBy(AbstractQuery.OrderBy orderBy) {
        this.orderBy = orderBy;
    }

    public static class Aggregation {
        private final String fieldName;
        private final Type aggregationType;
        private final Set<String> groupByTagsProjection;

        public Aggregation(String fieldName, Type aggregationType, Set<String> groupByTagsProjection) {
            this.fieldName = fieldName;
            this.aggregationType = aggregationType;
            this.groupByTagsProjection = groupByTagsProjection;
        }

        public static enum Type {
            UNSPECIFIED(BanyandbModel.AggregationFunction.AGGREGATION_FUNCTION_UNSPECIFIED),
            MEAN(BanyandbModel.AggregationFunction.AGGREGATION_FUNCTION_MEAN),
            MAX(BanyandbModel.AggregationFunction.AGGREGATION_FUNCTION_MAX),
            MIN(BanyandbModel.AggregationFunction.AGGREGATION_FUNCTION_MIN),
            COUNT(BanyandbModel.AggregationFunction.AGGREGATION_FUNCTION_COUNT),
            SUM(BanyandbModel.AggregationFunction.AGGREGATION_FUNCTION_SUM);

            final BanyandbModel.AggregationFunction function;

            private Type(BanyandbModel.AggregationFunction function) {
                this.function = function;
            }
        }
    }

    public static class TopN {
        private final String fieldName;
        private final int number;
        private final AbstractQuery.Sort sort;

        public TopN(String fieldName, int number, AbstractQuery.Sort sort) {
            this.fieldName = fieldName;
            this.number = number;
            this.sort = sort;
        }
    }
}

