/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.v1.client.metadata.;
import org.apache.skywalking.banyandb.v1.client.metadata.NamedSchema;
import org.apache.skywalking.banyandb.v1.client.util.TimeUtils;

@AutoValue
public abstract class IndexRule
extends NamedSchema<BanyandbDatabase.IndexRule> {
    abstract ImmutableList<String> tags();

    abstract IndexType indexType();

    @Nullable
    abstract Analyzer analyzer();

    abstract Builder toBuilder();

    public final IndexRule withGroup(String group) {
        return this.toBuilder().setGroup(group).build();
    }

    public final IndexRule withAnalyzer(Analyzer analyzer) {
        return this.toBuilder().setAnalyzer(analyzer).build();
    }

    public static IndexRule create(String name, IndexType indexType) {
        return new .AutoValue_IndexRule.Builder().setName(name).setTags((ImmutableList<String>)ImmutableList.of((Object)name)).setIndexType(indexType).build();
    }

    @VisibleForTesting
    static IndexRule create(String group, String name, IndexType indexType) {
        return new .AutoValue_IndexRule.Builder().setGroup(group).setName(name).setTags((ImmutableList<String>)ImmutableList.of((Object)name)).setIndexType(indexType).build();
    }

    @Override
    public BanyandbDatabase.IndexRule serialize() {
        BanyandbDatabase.IndexRule.Builder b = BanyandbDatabase.IndexRule.newBuilder().setMetadata(this.buildMetadata()).addAllTags((Iterable<String>)this.tags()).setType(this.indexType().type);
        Analyzer a = this.analyzer();
        if (a != null) {
            b.setAnalyzer(a.analyzer);
        }
        if (this.updatedAt() != null) {
            b.setUpdatedAt(TimeUtils.buildTimestamp(this.updatedAt()));
        }
        return b.build();
    }

    public static IndexRule fromProtobuf(BanyandbDatabase.IndexRule pb) {
        IndexType indexType = IndexType.fromProtobuf(pb.getType());
        Analyzer analyzer = Analyzer.fromProtobuf(pb.getAnalyzer());
        return new .AutoValue_IndexRule.Builder().setGroup(pb.getMetadata().getGroup()).setName(pb.getMetadata().getName()).setUpdatedAt(TimeUtils.parseTimestamp(pb.getUpdatedAt())).setIndexType(indexType).setAnalyzer(analyzer).setTags((ImmutableList<String>)ImmutableList.copyOf((Collection)pb.getTagsList())).build();
    }

    public static enum Analyzer {
        KEYWORD(BanyandbDatabase.IndexRule.Analyzer.ANALYZER_KEYWORD),
        STANDARD(BanyandbDatabase.IndexRule.Analyzer.ANALYZER_STANDARD),
        SIMPLE(BanyandbDatabase.IndexRule.Analyzer.ANALYZER_SIMPLE);

        private final BanyandbDatabase.IndexRule.Analyzer analyzer;

        private static Analyzer fromProtobuf(BanyandbDatabase.IndexRule.Analyzer analyzer) {
            switch (analyzer) {
                case ANALYZER_KEYWORD: {
                    return KEYWORD;
                }
                case ANALYZER_SIMPLE: {
                    return SIMPLE;
                }
                case ANALYZER_STANDARD: {
                    return STANDARD;
                }
                case ANALYZER_UNSPECIFIED: {
                    return null;
                }
            }
            throw new IllegalArgumentException("unrecognized analyzer");
        }

        private Analyzer(BanyandbDatabase.IndexRule.Analyzer analyzer) {
            this.analyzer = analyzer;
        }
    }

    public static enum IndexType {
        INVERTED(BanyandbDatabase.IndexRule.Type.TYPE_INVERTED);

        private final BanyandbDatabase.IndexRule.Type type;

        private static IndexType fromProtobuf(BanyandbDatabase.IndexRule.Type type) {
            if (Objects.requireNonNull(type) == BanyandbDatabase.IndexRule.Type.TYPE_INVERTED) {
                return INVERTED;
            }
            throw new IllegalArgumentException("unrecognized index type");
        }

        private IndexType(BanyandbDatabase.IndexRule.Type type) {
            this.type = type;
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setGroup(String var1);

        abstract Builder setName(String var1);

        abstract Builder setTags(ImmutableList<String> var1);

        abstract Builder setIndexType(IndexType var1);

        abstract Builder setAnalyzer(Analyzer var1);

        abstract Builder setUpdatedAt(ZonedDateTime var1);

        abstract IndexRule build();
    }
}

