/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.property.v1;

import com.google.protobuf.GeneratedMessageV3;
import io.envoyproxy.pgv.RepeatedValidation;
import io.envoyproxy.pgv.RequiredValidation;
import io.envoyproxy.pgv.ValidationException;
import io.envoyproxy.pgv.ValidatorImpl;
import io.envoyproxy.pgv.ValidatorIndex;
import java.util.List;
import org.apache.skywalking.banyandb.property.v1.BanyandbProperty;

public class BanyandbPropertyValidator {
    public static ValidatorImpl validatorFor(Class clazz) {
        if (clazz.equals(BanyandbProperty.Metadata.class)) {
            return new MetadataValidator();
        }
        if (clazz.equals(BanyandbProperty.Property.class)) {
            return new PropertyValidator();
        }
        if (clazz.equals(BanyandbProperty.ApplyRequest.class)) {
            return new ApplyRequestValidator();
        }
        if (clazz.equals(BanyandbProperty.ApplyResponse.class)) {
            return new ApplyResponseValidator();
        }
        if (clazz.equals(BanyandbProperty.DeleteRequest.class)) {
            return new DeleteRequestValidator();
        }
        if (clazz.equals(BanyandbProperty.DeleteResponse.class)) {
            return new DeleteResponseValidator();
        }
        if (clazz.equals(BanyandbProperty.GetRequest.class)) {
            return new GetRequestValidator();
        }
        if (clazz.equals(BanyandbProperty.GetResponse.class)) {
            return new GetResponseValidator();
        }
        if (clazz.equals(BanyandbProperty.ListRequest.class)) {
            return new ListRequestValidator();
        }
        if (clazz.equals(BanyandbProperty.ListResponse.class)) {
            return new ListResponseValidator();
        }
        if (clazz.equals(BanyandbProperty.KeepAliveRequest.class)) {
            return new KeepAliveRequestValidator();
        }
        if (clazz.equals(BanyandbProperty.KeepAliveResponse.class)) {
            return new KeepAliveResponseValidator();
        }
        return null;
    }

    public static class MetadataValidator
    implements ValidatorImpl<BanyandbProperty.Metadata> {
        public void assertValid(BanyandbProperty.Metadata proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasContainer()) {
                index.validatorFor((Object)proto.getContainer()).assertValid((Object)proto.getContainer());
            }
        }
    }

    public static class PropertyValidator
    implements ValidatorImpl<BanyandbProperty.Property> {
        public void assertValid(BanyandbProperty.Property proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasMetadata()) {
                index.validatorFor((Object)proto.getMetadata()).assertValid((Object)proto.getMetadata());
            }
            RepeatedValidation.forEach(proto.getTagsList(), item -> index.validatorFor(item).assertValid(item));
            if (proto.hasUpdatedAt()) {
                index.validatorFor((Object)proto.getUpdatedAt()).assertValid((Object)proto.getUpdatedAt());
            }
        }
    }

    public static class ApplyRequestValidator
    implements ValidatorImpl<BanyandbProperty.ApplyRequest> {
        public void assertValid(BanyandbProperty.ApplyRequest proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasProperty()) {
                RequiredValidation.required((String)".banyandb.property.v1.ApplyRequest.property", (GeneratedMessageV3)proto.getProperty());
            } else {
                RequiredValidation.required((String)".banyandb.property.v1.ApplyRequest.property", null);
            }
            if (proto.hasProperty()) {
                index.validatorFor((Object)proto.getProperty()).assertValid((Object)proto.getProperty());
            }
        }
    }

    public static class ApplyResponseValidator
    implements ValidatorImpl<BanyandbProperty.ApplyResponse> {
        public void assertValid(BanyandbProperty.ApplyResponse proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class DeleteRequestValidator
    implements ValidatorImpl<BanyandbProperty.DeleteRequest> {
        public void assertValid(BanyandbProperty.DeleteRequest proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasMetadata()) {
                RequiredValidation.required((String)".banyandb.property.v1.DeleteRequest.metadata", (GeneratedMessageV3)proto.getMetadata());
            } else {
                RequiredValidation.required((String)".banyandb.property.v1.DeleteRequest.metadata", null);
            }
            if (proto.hasMetadata()) {
                index.validatorFor((Object)proto.getMetadata()).assertValid((Object)proto.getMetadata());
            }
            RepeatedValidation.forEach((List)proto.getTagsList(), item -> {});
        }
    }

    public static class DeleteResponseValidator
    implements ValidatorImpl<BanyandbProperty.DeleteResponse> {
        public void assertValid(BanyandbProperty.DeleteResponse proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class GetRequestValidator
    implements ValidatorImpl<BanyandbProperty.GetRequest> {
        public void assertValid(BanyandbProperty.GetRequest proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasMetadata()) {
                RequiredValidation.required((String)".banyandb.property.v1.GetRequest.metadata", (GeneratedMessageV3)proto.getMetadata());
            } else {
                RequiredValidation.required((String)".banyandb.property.v1.GetRequest.metadata", null);
            }
            if (proto.hasMetadata()) {
                index.validatorFor((Object)proto.getMetadata()).assertValid((Object)proto.getMetadata());
            }
            RepeatedValidation.forEach((List)proto.getTagsList(), item -> {});
        }
    }

    public static class GetResponseValidator
    implements ValidatorImpl<BanyandbProperty.GetResponse> {
        public void assertValid(BanyandbProperty.GetResponse proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasProperty()) {
                index.validatorFor((Object)proto.getProperty()).assertValid((Object)proto.getProperty());
            }
        }
    }

    public static class ListRequestValidator
    implements ValidatorImpl<BanyandbProperty.ListRequest> {
        public void assertValid(BanyandbProperty.ListRequest proto, ValidatorIndex index) throws ValidationException {
            if (proto.hasContainer()) {
                RequiredValidation.required((String)".banyandb.property.v1.ListRequest.container", (GeneratedMessageV3)proto.getContainer());
            } else {
                RequiredValidation.required((String)".banyandb.property.v1.ListRequest.container", null);
            }
            if (proto.hasContainer()) {
                index.validatorFor((Object)proto.getContainer()).assertValid((Object)proto.getContainer());
            }
            RepeatedValidation.forEach((List)proto.getIdsList(), item -> {});
            RepeatedValidation.forEach((List)proto.getTagsList(), item -> {});
        }
    }

    public static class ListResponseValidator
    implements ValidatorImpl<BanyandbProperty.ListResponse> {
        public void assertValid(BanyandbProperty.ListResponse proto, ValidatorIndex index) throws ValidationException {
            RepeatedValidation.forEach(proto.getPropertyList(), item -> index.validatorFor(item).assertValid(item));
        }
    }

    public static class KeepAliveRequestValidator
    implements ValidatorImpl<BanyandbProperty.KeepAliveRequest> {
        public void assertValid(BanyandbProperty.KeepAliveRequest proto, ValidatorIndex index) throws ValidationException {
        }
    }

    public static class KeepAliveResponseValidator
    implements ValidatorImpl<BanyandbProperty.KeepAliveResponse> {
        public void assertValid(BanyandbProperty.KeepAliveResponse proto, ValidatorIndex index) throws ValidationException {
        }
    }
}

