/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client.metadata;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.v1.client.BanyanDBClient;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.util.CopyOnWriteMap;

public class MetadataCache {
    private final Map<String, EntityMetadata> cache = new CopyOnWriteMap<String, EntityMetadata>();
    private final BanyanDBClient client;

    public MetadataCache(BanyanDBClient client) {
        this.client = client;
    }

    public EntityMetadata register(BanyandbDatabase.Stream stream) {
        if (stream == null) {
            return null;
        }
        EntityMetadata metadata = MetadataCache.parse(stream);
        this.cache.put(MetadataCache.formatKey(stream.getMetadata().getGroup(), stream.getMetadata().getName()), metadata);
        return metadata;
    }

    public EntityMetadata unregister(BanyandbDatabase.Stream stream) {
        if (stream == null) {
            return null;
        }
        return this.cache.remove(MetadataCache.formatKey(stream.getMetadata().getGroup(), stream.getMetadata().getName()));
    }

    public EntityMetadata register(BanyandbDatabase.Measure measure) {
        if (measure == null) {
            return null;
        }
        EntityMetadata metadata = MetadataCache.parse(measure);
        this.cache.put(MetadataCache.formatKey(measure.getMetadata().getGroup(), measure.getMetadata().getName()), metadata);
        return metadata;
    }

    public EntityMetadata unregister(BanyandbDatabase.Measure measure) {
        if (measure == null) {
            return null;
        }
        return this.cache.remove(MetadataCache.formatKey(measure.getMetadata().getGroup(), measure.getMetadata().getName()));
    }

    public EntityMetadata unregister(String group, String name) {
        return this.cache.remove(MetadataCache.formatKey(group, name));
    }

    public EntityMetadata findStreamMetadata(String group, String name) throws BanyanDBException {
        EntityMetadata metadata = this.cache.get(MetadataCache.formatKey(group, name));
        if (metadata != null) {
            return metadata;
        }
        return this.register(this.client.findStream(group, name));
    }

    public EntityMetadata findMeasureMetadata(String group, String name) throws BanyanDBException {
        EntityMetadata metadata = this.cache.get(MetadataCache.formatKey(group, name));
        if (metadata != null) {
            return metadata;
        }
        return this.register(this.client.findMeasure(group, name));
    }

    public EntityMetadata updateStreamFromSever(String group, String name) throws BanyanDBException {
        return this.register(this.client.findStream(group, name));
    }

    public EntityMetadata updateMeasureFromSever(String group, String name) throws BanyanDBException {
        return this.register(this.client.findMeasure(group, name));
    }

    static String formatKey(String group, String name) {
        return group + ":" + name;
    }

    static EntityMetadata parse(BanyandbDatabase.Stream s) {
        int totalTags = 0;
        int[] tagFamilyCapacity = new int[s.getTagFamiliesList().size()];
        HashMap<String, TagInfo> tagInfo = new HashMap<String, TagInfo>();
        int k = 0;
        for (int i = 0; i < s.getTagFamiliesList().size(); ++i) {
            String tagFamilyName = s.getTagFamiliesList().get(i).getName();
            tagFamilyCapacity[i] = s.getTagFamiliesList().get(i).getTagsList().size();
            totalTags += tagFamilyCapacity[i];
            for (int j = 0; j < tagFamilyCapacity[i]; ++j) {
                tagInfo.put(s.getTagFamiliesList().get(i).getTagsList().get(j).getName(), new TagInfo(tagFamilyName, k++));
            }
        }
        return new EntityMetadata(s.getMetadata().getGroup(), s.getMetadata().getName(), s.getMetadata().getModRevision(), totalTags, 0, tagFamilyCapacity, Collections.unmodifiableMap(tagInfo), Collections.emptyMap());
    }

    static EntityMetadata parse(BanyandbDatabase.Measure m) {
        int totalTags = 0;
        int[] tagFamilyCapacity = new int[m.getTagFamiliesList().size()];
        HashMap<String, TagInfo> tagOffset = new HashMap<String, TagInfo>();
        int k = 0;
        for (int i = 0; i < m.getTagFamiliesList().size(); ++i) {
            String tagFamilyName = m.getTagFamiliesList().get(i).getName();
            tagFamilyCapacity[i] = m.getTagFamiliesList().get(i).getTagsList().size();
            totalTags += tagFamilyCapacity[i];
            for (int j = 0; j < tagFamilyCapacity[i]; ++j) {
                tagOffset.put(m.getTagFamiliesList().get(i).getTagsList().get(j).getName(), new TagInfo(tagFamilyName, k++));
            }
        }
        HashMap<String, Integer> fieldOffset = new HashMap<String, Integer>();
        for (int i = 0; i < m.getFieldsList().size(); ++i) {
            fieldOffset.put(m.getFieldsList().get(i).getName(), i);
        }
        return new EntityMetadata(m.getMetadata().getGroup(), m.getMetadata().getName(), m.getMetadata().getModRevision(), totalTags, m.getFieldsList().size(), tagFamilyCapacity, Collections.unmodifiableMap(tagOffset), Collections.unmodifiableMap(fieldOffset));
    }

    public static class EntityMetadata {
        private final String group;
        private final String name;
        private final long modRevision;
        private final int totalTags;
        private final int totalFields;
        private final int[] tagFamilyCapacity;
        private final Map<String, TagInfo> tagOffset;
        private final Map<String, Integer> fieldOffset;

        public Optional<TagInfo> findTagInfo(String name) {
            return Optional.ofNullable(this.tagOffset.get(name));
        }

        public int findFieldInfo(String name) {
            return this.fieldOffset.get(name);
        }

        public String getGroup() {
            return this.group;
        }

        public String getName() {
            return this.name;
        }

        public long getModRevision() {
            return this.modRevision;
        }

        public int getTotalTags() {
            return this.totalTags;
        }

        public int getTotalFields() {
            return this.totalFields;
        }

        public int[] getTagFamilyCapacity() {
            return this.tagFamilyCapacity;
        }

        public Map<String, TagInfo> getTagOffset() {
            return this.tagOffset;
        }

        public Map<String, Integer> getFieldOffset() {
            return this.fieldOffset;
        }

        public EntityMetadata(String group, String name, long modRevision, int totalTags, int totalFields, int[] tagFamilyCapacity, Map<String, TagInfo> tagOffset, Map<String, Integer> fieldOffset) {
            this.group = group;
            this.name = name;
            this.modRevision = modRevision;
            this.totalTags = totalTags;
            this.totalFields = totalFields;
            this.tagFamilyCapacity = tagFamilyCapacity;
            this.tagOffset = tagOffset;
            this.fieldOffset = fieldOffset;
        }
    }

    public static class TagInfo {
        private final String tagFamilyName;
        private final int offset;

        public TagInfo(String tagFamilyName, int offset) {
            this.tagFamilyName = tagFamilyName;
            this.offset = offset;
        }

        public String getTagFamilyName() {
            return this.tagFamilyName;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

