/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.protobuf.Timestamp;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.skywalking.banyandb.common.v1.BanyandbCommon;
import org.apache.skywalking.banyandb.common.v1.ServiceGrpc;
import org.apache.skywalking.banyandb.database.v1.BanyandbDatabase;
import org.apache.skywalking.banyandb.measure.v1.BanyandbMeasure;
import org.apache.skywalking.banyandb.measure.v1.MeasureServiceGrpc;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.property.v1.BanyandbProperty;
import org.apache.skywalking.banyandb.stream.v1.BanyandbStream;
import org.apache.skywalking.banyandb.stream.v1.StreamServiceGrpc;
import org.apache.skywalking.banyandb.v1.client.MeasureBulkWriteProcessor;
import org.apache.skywalking.banyandb.v1.client.MeasureQuery;
import org.apache.skywalking.banyandb.v1.client.MeasureQueryResponse;
import org.apache.skywalking.banyandb.v1.client.MeasureWrite;
import org.apache.skywalking.banyandb.v1.client.Options;
import org.apache.skywalking.banyandb.v1.client.PropertyStore;
import org.apache.skywalking.banyandb.v1.client.StreamBulkWriteProcessor;
import org.apache.skywalking.banyandb.v1.client.StreamQuery;
import org.apache.skywalking.banyandb.v1.client.StreamQueryResponse;
import org.apache.skywalking.banyandb.v1.client.StreamWrite;
import org.apache.skywalking.banyandb.v1.client.TopNQuery;
import org.apache.skywalking.banyandb.v1.client.TopNQueryResponse;
import org.apache.skywalking.banyandb.v1.client.grpc.HandleExceptionsWith;
import org.apache.skywalking.banyandb.v1.client.grpc.channel.ChannelManager;
import org.apache.skywalking.banyandb.v1.client.grpc.channel.DefaultChannelFactory;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.InternalException;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.InvalidArgumentException;
import org.apache.skywalking.banyandb.v1.client.metadata.GroupMetadataRegistry;
import org.apache.skywalking.banyandb.v1.client.metadata.IndexRuleBindingMetadataRegistry;
import org.apache.skywalking.banyandb.v1.client.metadata.IndexRuleMetadataRegistry;
import org.apache.skywalking.banyandb.v1.client.metadata.MeasureMetadataRegistry;
import org.apache.skywalking.banyandb.v1.client.metadata.MetadataCache;
import org.apache.skywalking.banyandb.v1.client.metadata.ResourceExist;
import org.apache.skywalking.banyandb.v1.client.metadata.StreamMetadataRegistry;
import org.apache.skywalking.banyandb.v1.client.metadata.TopNAggregationMetadataRegistry;
import org.apache.skywalking.banyandb.v1.client.util.StatusUtil;
import org.apache.skywalking.banyandb.v1.client.util.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BanyanDBClient
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(BanyanDBClient.class);
    public static final ZonedDateTime DEFAULT_EXPIRE_AT = ZonedDateTime.of(2099, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC);
    private final String[] targets;
    private final Options options;
    private volatile Channel channel;
    private StreamServiceGrpc.StreamServiceStub streamServiceStub;
    private MeasureServiceGrpc.MeasureServiceStub measureServiceStub;
    private StreamServiceGrpc.StreamServiceBlockingStub streamServiceBlockingStub;
    private MeasureServiceGrpc.MeasureServiceBlockingStub measureServiceBlockingStub;
    private volatile boolean isConnected = false;
    private final ReentrantLock connectionEstablishLock;
    private final MetadataCache metadataCache;

    public BanyanDBClient(String ... targets) {
        this(targets, new Options());
    }

    public BanyanDBClient(String[] targets, Options options) {
        String[] tt = (String[])Preconditions.checkNotNull((Object)targets, (Object)"targets");
        Preconditions.checkState((tt.length > 0 ? 1 : 0) != 0, (Object)"targets' size must be more than 1");
        tt = (String[])Arrays.stream(tt).filter(t -> !Strings.isNullOrEmpty((String)t)).toArray(String[]::new);
        Preconditions.checkState((tt.length > 0 ? 1 : 0) != 0, (Object)"valid targets' size must be more than 1");
        this.targets = tt;
        this.options = options;
        this.connectionEstablishLock = new ReentrantLock();
        this.metadataCache = new MetadataCache(this);
    }

    public void connect() throws IOException {
        this.connectionEstablishLock.lock();
        try {
            if (!this.isConnected) {
                URI[] addresses = new URI[this.targets.length];
                for (int i = 0; i < this.targets.length; ++i) {
                    addresses[i] = URI.create("//" + this.targets[i]);
                }
                this.channel = ChannelManager.create(this.options.buildChannelManagerSettings(), new DefaultChannelFactory(addresses, this.options));
                this.streamServiceBlockingStub = StreamServiceGrpc.newBlockingStub(this.channel);
                this.measureServiceBlockingStub = MeasureServiceGrpc.newBlockingStub(this.channel);
                this.streamServiceStub = StreamServiceGrpc.newStub(this.channel);
                this.measureServiceStub = MeasureServiceGrpc.newStub(this.channel);
                this.isConnected = true;
            }
        }
        finally {
            this.connectionEstablishLock.unlock();
        }
    }

    @VisibleForTesting
    void connect(Channel channel) {
        this.connectionEstablishLock.lock();
        try {
            if (!this.isConnected) {
                this.channel = channel;
                this.streamServiceBlockingStub = StreamServiceGrpc.newBlockingStub(this.channel);
                this.measureServiceBlockingStub = MeasureServiceGrpc.newBlockingStub(this.channel);
                this.streamServiceStub = StreamServiceGrpc.newStub(this.channel);
                this.measureServiceStub = MeasureServiceGrpc.newStub(this.channel);
                this.isConnected = true;
            }
        }
        finally {
            this.connectionEstablishLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CompletableFuture<Void> write(final StreamWrite streamWrite) {
        Preconditions.checkState((this.streamServiceStub != null ? 1 : 0) != 0, (Object)"stream service is null");
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        StreamObserver<BanyandbStream.WriteRequest> writeRequestStreamObserver = ((StreamServiceGrpc.StreamServiceStub)this.streamServiceStub.withDeadlineAfter(this.getOptions().getDeadline(), TimeUnit.SECONDS)).write(new StreamObserver<BanyandbStream.WriteResponse>(){
            private BanyanDBException responseException;

            public void onNext(BanyandbStream.WriteResponse writeResponse) {
                BanyandbModel.Status status = StatusUtil.convertStringToStatus(writeResponse.getStatus());
                switch (status) {
                    case STATUS_SUCCEED: {
                        break;
                    }
                    case STATUS_INVALID_TIMESTAMP: {
                        this.responseException = new InvalidArgumentException("Invalid timestamp: " + streamWrite.getTimestamp(), null, Status.Code.INVALID_ARGUMENT, false);
                        break;
                    }
                    case STATUS_NOT_FOUND: {
                        this.responseException = new InvalidArgumentException("Invalid metadata: " + streamWrite.entityMetadata, null, Status.Code.INVALID_ARGUMENT, false);
                        break;
                    }
                    case STATUS_EXPIRED_SCHEMA: {
                        BanyandbCommon.Metadata metadata = writeResponse.getMetadata();
                        log.warn("The schema {}.{} is expired, trying update the schema...", (Object)metadata.getGroup(), (Object)metadata.getName());
                        try {
                            BanyanDBClient.this.updateStreamMetadataCacheFromSever(metadata.getGroup(), metadata.getName());
                        }
                        catch (BanyanDBException e) {
                            String warnMessage = String.format("Failed to refresh the stream schema %s.%s", metadata.getGroup(), metadata.getName());
                            log.warn(warnMessage, (Throwable)e);
                        }
                        this.responseException = new InvalidArgumentException("Expired revision: " + metadata.getModRevision(), null, Status.Code.INVALID_ARGUMENT, true);
                        break;
                    }
                    default: {
                        this.responseException = new InternalException(String.format("Internal error (%s) occurs in server", writeResponse.getStatus()), null, Status.Code.INTERNAL, true);
                    }
                }
            }

            public void onError(Throwable throwable) {
                log.error("Error occurs in flushing streams.", throwable);
                future.completeExceptionally(throwable);
            }

            public void onCompleted() {
                if (this.responseException == null) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(this.responseException);
                }
            }
        });
        try {
            writeRequestStreamObserver.onNext((Object)((BanyandbStream.WriteRequest)streamWrite.build()));
        }
        finally {
            writeRequestStreamObserver.onCompleted();
        }
        return future;
    }

    public StreamBulkWriteProcessor buildStreamWriteProcessor(int maxBulkSize, int flushInterval, int concurrency, int timeout) {
        Preconditions.checkState((this.streamServiceStub != null ? 1 : 0) != 0, (Object)"stream service is null");
        return new StreamBulkWriteProcessor(this, maxBulkSize, flushInterval, concurrency, timeout);
    }

    public MeasureBulkWriteProcessor buildMeasureWriteProcessor(int maxBulkSize, int flushInterval, int concurrency, int timeout) {
        Preconditions.checkState((this.measureServiceStub != null ? 1 : 0) != 0, (Object)"measure service is null");
        return new MeasureBulkWriteProcessor(this, maxBulkSize, flushInterval, concurrency, timeout);
    }

    public MeasureWrite createMeasureWrite(String group, String name, long timestamp) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new MeasureWrite(this.metadataCache.findMeasureMetadata(group, name), timestamp);
    }

    public StreamWrite createStreamWrite(String group, String name, String elementId) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new StreamWrite(this.metadataCache.findStreamMetadata(group, name), elementId);
    }

    public StreamWrite createStreamWrite(String group, String name, String elementId, long timestamp) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new StreamWrite(this.metadataCache.findStreamMetadata(group, name), elementId, timestamp);
    }

    public StreamQueryResponse query(StreamQuery streamQuery) throws BanyanDBException {
        Preconditions.checkState((this.streamServiceStub != null ? 1 : 0) != 0, (Object)"stream service is null");
        for (String group : streamQuery.groups) {
            MetadataCache.EntityMetadata em = this.metadataCache.findStreamMetadata(group, streamQuery.name);
            if (em == null) continue;
            BanyandbStream.QueryResponse response = HandleExceptionsWith.callAndTranslateApiException(() -> ((StreamServiceGrpc.StreamServiceBlockingStub)this.streamServiceBlockingStub.withDeadlineAfter(this.getOptions().getDeadline(), TimeUnit.SECONDS)).query(streamQuery.build(em)));
            return new StreamQueryResponse(response);
        }
        throw new RuntimeException("No metadata found for the query");
    }

    public TopNQueryResponse query(TopNQuery topNQuery) throws BanyanDBException {
        Preconditions.checkState((this.measureServiceStub != null ? 1 : 0) != 0, (Object)"measure service is null");
        BanyandbMeasure.TopNResponse response = HandleExceptionsWith.callAndTranslateApiException(() -> ((MeasureServiceGrpc.MeasureServiceBlockingStub)this.measureServiceBlockingStub.withDeadlineAfter(this.getOptions().getDeadline(), TimeUnit.SECONDS)).topN(topNQuery.build()));
        return new TopNQueryResponse(response);
    }

    public MeasureQueryResponse query(MeasureQuery measureQuery) throws BanyanDBException {
        Preconditions.checkState((this.streamServiceStub != null ? 1 : 0) != 0, (Object)"measure service is null");
        for (String group : measureQuery.groups) {
            MetadataCache.EntityMetadata em = this.metadataCache.findMeasureMetadata(group, measureQuery.name);
            if (em == null) continue;
            BanyandbMeasure.QueryResponse response = HandleExceptionsWith.callAndTranslateApiException(() -> ((MeasureServiceGrpc.MeasureServiceBlockingStub)this.measureServiceBlockingStub.withDeadlineAfter(this.getOptions().getDeadline(), TimeUnit.SECONDS)).query(measureQuery.build(em)));
            return new MeasureQueryResponse(response);
        }
        throw new RuntimeException("No metadata found for the query");
    }

    public BanyandbCommon.Group define(BanyandbCommon.Group group) throws BanyanDBException {
        GroupMetadataRegistry registry = new GroupMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.create(group);
        return registry.get(null, group.getMetadata().getName());
    }

    public void define(BanyandbDatabase.Stream stream) throws BanyanDBException {
        StreamMetadataRegistry streamRegistry = new StreamMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        long modRevision = streamRegistry.create(stream);
        stream = stream.toBuilder().setMetadata(stream.getMetadata().toBuilder().setModRevision(modRevision)).build();
        this.metadataCache.register(stream);
    }

    public void define(BanyandbDatabase.Stream stream, List<BanyandbDatabase.IndexRule> indexRules) throws BanyanDBException {
        this.define(stream);
        this.defineIndexRules(stream, indexRules);
    }

    public void define(BanyandbDatabase.Measure measure) throws BanyanDBException {
        MeasureMetadataRegistry measureRegistry = new MeasureMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        long modRevision = measureRegistry.create(measure);
        measure = measure.toBuilder().setMetadata(measure.getMetadata().toBuilder().setModRevision(modRevision)).build();
        this.metadataCache.register(measure);
    }

    public void define(BanyandbDatabase.Measure measure, List<BanyandbDatabase.IndexRule> indexRules) throws BanyanDBException {
        this.define(measure);
        this.defineIndexRules(measure, indexRules);
    }

    public void define(BanyandbDatabase.TopNAggregation topNAggregation) throws BanyanDBException {
        TopNAggregationMetadataRegistry registry = new TopNAggregationMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.create(topNAggregation);
    }

    public void define(BanyandbDatabase.IndexRule indexRule) throws BanyanDBException {
        IndexRuleMetadataRegistry registry = new IndexRuleMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.create(indexRule);
    }

    public void define(BanyandbDatabase.IndexRuleBinding indexRuleBinding) throws BanyanDBException {
        ZonedDateTime beginAt = indexRuleBinding.getBeginAt() == Timestamp.getDefaultInstance() ? ZonedDateTime.now() : TimeUtils.parseTimestamp(indexRuleBinding.getBeginAt());
        ZonedDateTime expireAt = indexRuleBinding.getExpireAt() == Timestamp.getDefaultInstance() ? DEFAULT_EXPIRE_AT : TimeUtils.parseTimestamp(indexRuleBinding.getExpireAt());
        this.define(indexRuleBinding, beginAt, expireAt);
    }

    public void define(BanyandbDatabase.IndexRuleBinding indexRuleBinding, ZonedDateTime beginAt, ZonedDateTime expireAt) throws BanyanDBException {
        IndexRuleBindingMetadataRegistry registry = new IndexRuleBindingMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        indexRuleBinding = indexRuleBinding.toBuilder().setBeginAt(TimeUtils.buildTimestamp(beginAt)).setExpireAt(TimeUtils.buildTimestamp(expireAt)).build();
        registry.create(indexRuleBinding);
    }

    public void defineIndexRules(BanyandbDatabase.Stream stream, List<BanyandbDatabase.IndexRule> indexRules) throws BanyanDBException {
        Preconditions.checkArgument((stream != null ? 1 : 0) != 0, (Object)"stream cannot be null");
        IndexRuleMetadataRegistry irRegistry = new IndexRuleMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        for (BanyandbDatabase.IndexRule ir : indexRules) {
            try {
                irRegistry.create(ir);
            }
            catch (BanyanDBException ex) {
                if (ex.getStatus().equals((Object)Status.Code.ALREADY_EXISTS)) continue;
                throw ex;
            }
        }
        if (indexRules.isEmpty()) {
            return;
        }
        List<String> indexRuleNames = indexRules.stream().map(indexRule -> indexRule.getMetadata().getName()).collect(Collectors.toList());
        BanyandbDatabase.IndexRuleBinding binding = BanyandbDatabase.IndexRuleBinding.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(stream.getMetadata().getGroup()).setName(stream.getMetadata().getName())).setSubject(BanyandbDatabase.Subject.newBuilder().setName(stream.getMetadata().getName()).setCatalog(BanyandbCommon.Catalog.CATALOG_STREAM)).addAllRules(indexRuleNames).build();
        this.define(binding);
    }

    public void defineIndexRules(BanyandbDatabase.Measure measure, List<BanyandbDatabase.IndexRule> indexRules) throws BanyanDBException {
        Preconditions.checkArgument((measure != null ? 1 : 0) != 0, (Object)"measure cannot be null");
        IndexRuleMetadataRegistry irRegistry = new IndexRuleMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        for (BanyandbDatabase.IndexRule ir : indexRules) {
            try {
                irRegistry.create(ir);
            }
            catch (BanyanDBException ex) {
                if (ex.getStatus().equals((Object)Status.Code.ALREADY_EXISTS)) continue;
                throw ex;
            }
        }
        if (indexRules.isEmpty()) {
            return;
        }
        List<String> indexRuleNames = indexRules.stream().map(indexRule -> indexRule.getMetadata().getName()).collect(Collectors.toList());
        BanyandbDatabase.IndexRuleBinding binding = BanyandbDatabase.IndexRuleBinding.newBuilder().setMetadata(BanyandbCommon.Metadata.newBuilder().setGroup(measure.getMetadata().getGroup()).setName(measure.getMetadata().getName())).setSubject(BanyandbDatabase.Subject.newBuilder().setName(measure.getMetadata().getName()).setCatalog(BanyandbCommon.Catalog.CATALOG_MEASURE)).addAllRules(indexRuleNames).build();
        this.define(binding);
    }

    public void update(BanyandbCommon.Group group) throws BanyanDBException {
        GroupMetadataRegistry registry = new GroupMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.update(group);
    }

    public void update(BanyandbDatabase.Stream stream) throws BanyanDBException {
        StreamMetadataRegistry streamRegistry = new StreamMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        streamRegistry.update(stream);
        this.metadataCache.register(stream);
    }

    public void update(BanyandbDatabase.Measure measure) throws BanyanDBException {
        MeasureMetadataRegistry measureRegistry = new MeasureMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        measureRegistry.update(measure);
        this.metadataCache.register(measure);
    }

    public void update(BanyandbDatabase.TopNAggregation topNAggregation) throws BanyanDBException {
        TopNAggregationMetadataRegistry registry = new TopNAggregationMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.update(topNAggregation);
    }

    public void update(BanyandbDatabase.IndexRule indexRule) throws BanyanDBException {
        IndexRuleMetadataRegistry registry = new IndexRuleMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.update(indexRule);
    }

    public void update(BanyandbDatabase.IndexRuleBinding indexRuleBinding) throws BanyanDBException {
        IndexRuleBindingMetadataRegistry registry = new IndexRuleBindingMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        registry.update(indexRuleBinding);
    }

    public boolean deleteGroup(String name) throws BanyanDBException {
        GroupMetadataRegistry registry = new GroupMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.delete(name, name);
    }

    public boolean deleteStream(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        StreamMetadataRegistry streamRegistry = new StreamMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        if (streamRegistry.delete(group, name)) {
            this.metadataCache.unregister(group, name);
            return true;
        }
        return false;
    }

    public boolean deleteMeasure(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        MeasureMetadataRegistry measureRegistry = new MeasureMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        if (measureRegistry.delete(group, name)) {
            this.metadataCache.unregister(group, name);
            return true;
        }
        return false;
    }

    public boolean deleteTopNAggregation(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        TopNAggregationMetadataRegistry registry = new TopNAggregationMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.delete(group, name);
    }

    public boolean deleteIndexRule(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        IndexRuleMetadataRegistry registry = new IndexRuleMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.delete(group, name);
    }

    public boolean deleteIndexRuleBinding(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        IndexRuleBindingMetadataRegistry registry = new IndexRuleBindingMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.delete(group, name);
    }

    public BanyandbDatabase.IndexRule findIndexRule(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        IndexRuleMetadataRegistry registry = new IndexRuleMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        try {
            return registry.get(group, name);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                return null;
            }
            throw ex;
        }
    }

    public List<BanyandbDatabase.IndexRule> findIndexRules(String group) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        IndexRuleMetadataRegistry registry = new IndexRuleMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.list(group);
    }

    public BanyandbDatabase.IndexRuleBinding findIndexRuleBinding(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        IndexRuleBindingMetadataRegistry registry = new IndexRuleBindingMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        try {
            return registry.get(group, name);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                return null;
            }
            throw ex;
        }
    }

    public List<BanyandbDatabase.IndexRuleBinding> findIndexRuleBindings(String group) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        IndexRuleBindingMetadataRegistry registry = new IndexRuleBindingMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.list(group);
    }

    public BanyandbProperty.ApplyResponse apply(BanyandbProperty.Property property) throws BanyanDBException {
        PropertyStore store = new PropertyStore((Channel)Preconditions.checkNotNull((Object)this.channel));
        return store.apply(property);
    }

    public BanyandbProperty.ApplyResponse apply(BanyandbProperty.Property property, BanyandbProperty.ApplyRequest.Strategy strategy) throws BanyanDBException {
        PropertyStore store = new PropertyStore((Channel)Preconditions.checkNotNull((Object)this.channel));
        return store.apply(property, strategy);
    }

    public BanyandbProperty.QueryResponse query(BanyandbProperty.QueryRequest request) throws BanyanDBException {
        PropertyStore store = new PropertyStore((Channel)Preconditions.checkNotNull((Object)this.channel));
        return store.query(request);
    }

    public BanyandbProperty.DeleteResponse deleteProperty(String group, String name, String id) throws BanyanDBException {
        PropertyStore store = new PropertyStore((Channel)Preconditions.checkNotNull((Object)this.channel));
        return store.delete(group, name, id);
    }

    public BanyandbCommon.Group findGroup(String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        try {
            return new GroupMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).get(name, name);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                return null;
            }
            throw ex;
        }
    }

    public List<BanyandbCommon.Group> findGroups() throws BanyanDBException {
        return new GroupMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).list("");
    }

    public BanyandbDatabase.TopNAggregation findTopNAggregation(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        try {
            return new TopNAggregationMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).get(group, name);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                return null;
            }
            throw ex;
        }
    }

    public List<BanyandbDatabase.TopNAggregation> findTopNAggregations(String group) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        return new TopNAggregationMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).list(group);
    }

    public BanyandbDatabase.Stream findStream(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        try {
            return new StreamMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).get(group, name);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                return null;
            }
            throw ex;
        }
    }

    public List<BanyandbDatabase.Stream> findStreams(String group) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        StreamMetadataRegistry registry = new StreamMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.list(group);
    }

    public BanyandbDatabase.Measure findMeasure(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        try {
            return new MeasureMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).get(group, name);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                return null;
            }
            throw ex;
        }
    }

    public List<BanyandbDatabase.Measure> findMeasures(String group) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        MeasureMetadataRegistry registry = new MeasureMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        return registry.list(group);
    }

    private List<BanyandbDatabase.IndexRule> findIndexRulesByGroupAndBindingName(String group, String bindingName) throws BanyanDBException {
        BanyandbDatabase.IndexRuleBinding irb;
        IndexRuleBindingMetadataRegistry irbRegistry = new IndexRuleBindingMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel));
        try {
            irb = irbRegistry.get(group, bindingName);
        }
        catch (BanyanDBException ex) {
            if (ex.getStatus().equals((Object)Status.Code.NOT_FOUND)) {
                return Collections.emptyList();
            }
            throw ex;
        }
        if (irb == null) {
            return Collections.emptyList();
        }
        ArrayList<BanyandbDatabase.IndexRule> indexRules = new ArrayList<BanyandbDatabase.IndexRule>(irb.getRulesList().size());
        return indexRules;
    }

    public ResourceExist existStream(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new StreamMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).exist(group, name);
    }

    public ResourceExist existMeasure(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new MeasureMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).exist(group, name);
    }

    public ResourceExist existTopNAggregation(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return new TopNAggregationMetadataRegistry((Channel)Preconditions.checkNotNull((Object)this.channel)).exist(group, name);
    }

    public MetadataCache.EntityMetadata updateStreamMetadataCacheFromSever(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return this.metadataCache.updateStreamFromSever(group, name);
    }

    public MetadataCache.EntityMetadata updateMeasureMetadataCacheFromSever(String group, String name) throws BanyanDBException {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)group) ? 1 : 0) != 0);
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        return this.metadataCache.updateMeasureFromSever(group, name);
    }

    public BanyandbCommon.APIVersion getAPIVersion() throws BanyanDBException {
        ServiceGrpc.ServiceBlockingStub stub = ServiceGrpc.newBlockingStub(this.channel);
        return HandleExceptionsWith.callAndTranslateApiException(() -> {
            BanyandbCommon.GetAPIVersionResponse resp = stub.getAPIVersion(BanyandbCommon.GetAPIVersionRequest.getDefaultInstance());
            return resp.getVersion();
        });
    }

    @Override
    public void close() throws IOException {
        this.connectionEstablishLock.lock();
        if (!(this.channel instanceof ManagedChannel)) {
            return;
        }
        ManagedChannel managedChannel = (ManagedChannel)this.channel;
        try {
            if (this.isConnected) {
                managedChannel.shutdown().awaitTermination(5L, TimeUnit.SECONDS);
                this.isConnected = false;
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            log.warn("fail to wait for channel termination, shutdown now!", (Throwable)interruptedException);
            managedChannel.shutdownNow();
            this.isConnected = false;
        }
        finally {
            this.connectionEstablishLock.unlock();
        }
    }

    Options getOptions() {
        return this.options;
    }

    Channel getChannel() {
        return this.channel;
    }

    StreamServiceGrpc.StreamServiceStub getStreamServiceStub() {
        return this.streamServiceStub;
    }

    MeasureServiceGrpc.MeasureServiceStub getMeasureServiceStub() {
        return this.measureServiceStub;
    }

    StreamServiceGrpc.StreamServiceBlockingStub getStreamServiceBlockingStub() {
        return this.streamServiceBlockingStub;
    }

    MeasureServiceGrpc.MeasureServiceBlockingStub getMeasureServiceBlockingStub() {
        return this.measureServiceBlockingStub;
    }
}

