/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import io.grpc.Channel;
import org.apache.skywalking.banyandb.property.v1.BanyandbProperty;
import org.apache.skywalking.banyandb.property.v1.PropertyServiceGrpc;
import org.apache.skywalking.banyandb.v1.client.grpc.HandleExceptionsWith;
import org.apache.skywalking.banyandb.v1.client.grpc.exception.BanyanDBException;

public class PropertyStore {
    private final PropertyServiceGrpc.PropertyServiceBlockingStub stub;

    public PropertyStore(Channel channel) {
        this.stub = PropertyServiceGrpc.newBlockingStub(channel);
    }

    public BanyandbProperty.ApplyResponse apply(BanyandbProperty.Property payload) throws BanyanDBException {
        return this.apply(payload, BanyandbProperty.ApplyRequest.Strategy.STRATEGY_MERGE);
    }

    public BanyandbProperty.ApplyResponse apply(BanyandbProperty.Property payload, BanyandbProperty.ApplyRequest.Strategy strategy) throws BanyanDBException {
        BanyandbProperty.ApplyRequest.Strategy s = BanyandbProperty.ApplyRequest.Strategy.STRATEGY_MERGE;
        BanyandbProperty.ApplyRequest r = BanyandbProperty.ApplyRequest.newBuilder().setProperty(payload).setStrategy(strategy).build();
        return HandleExceptionsWith.callAndTranslateApiException(() -> this.stub.apply(r));
    }

    public BanyandbProperty.DeleteResponse delete(String group, String name, String id) throws BanyanDBException {
        return HandleExceptionsWith.callAndTranslateApiException(() -> this.stub.delete(BanyandbProperty.DeleteRequest.newBuilder().setGroup(group).setContainer(name).setId(id).build()));
    }

    public BanyandbProperty.QueryResponse query(BanyandbProperty.QueryRequest req) throws BanyanDBException {
        return HandleExceptionsWith.callAndTranslateApiException(() -> this.stub.query(req));
    }
}

