/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.banyandb.v1.client;

import com.google.protobuf.ByteString;
import com.google.protobuf.NullValue;
import java.util.List;
import org.apache.skywalking.banyandb.model.v1.BanyandbModel;
import org.apache.skywalking.banyandb.v1.client.Value;

public abstract class TagAndValue<T>
extends Value<T> {
    protected final String tagName;

    protected TagAndValue(String tagName, T value) {
        super(value);
        this.tagName = tagName;
    }

    public String getTagName() {
        return this.tagName;
    }

    public boolean isNull() {
        return this.value == null;
    }

    protected abstract BanyandbModel.TagValue buildTypedTagValue();

    public BanyandbModel.Tag build() {
        return BanyandbModel.Tag.newBuilder().setKey(this.tagName).setValue(this.buildTypedTagValue()).build();
    }

    public static TagAndValue<?> fromProtobuf(BanyandbModel.Tag tag) {
        switch (tag.getValue().getValueCase()) {
            case INT: {
                return new LongTagPair(tag.getKey(), tag.getValue().getInt().getValue());
            }
            case STR: {
                return new StringTagPair(tag.getKey(), tag.getValue().getStr().getValue());
            }
            case INT_ARRAY: {
                return new LongArrayTagPair(tag.getKey(), tag.getValue().getIntArray().getValueList());
            }
            case STR_ARRAY: {
                return new StringArrayTagPair(tag.getKey(), (List<String>)tag.getValue().getStrArray().getValueList());
            }
            case BINARY_DATA: {
                return new BinaryTagPair(tag.getKey(), tag.getValue().getBinaryData());
            }
            case NULL: {
                return new NullTagPair(tag.getKey());
            }
        }
        throw new IllegalArgumentException("Unrecognized NullType");
    }

    public static TagAndValue<String> newStringTag(String tagName, String value) {
        return new StringTagPair(tagName, value);
    }

    public static TagAndValue<List<String>> newStringArrayTagPair(String tagName, List<String> value) {
        return new StringArrayTagPair(tagName, value);
    }

    public static TagAndValue<Long> newLongTag(String tagName, long value) {
        return new LongTagPair(tagName, value);
    }

    public static TagAndValue<Long> newLongArrayTag(String tagName, long value) {
        return new LongTagPair(tagName, value);
    }

    public static TagAndValue<ByteString> newBinaryTag(String tagName, byte[] bytes) {
        return new BinaryTagPair(tagName, ByteString.copyFrom((byte[])bytes));
    }

    public static TagAndValue<Void> newNullTag(String tagName) {
        return new NullTagPair(tagName);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TagAndValue)) {
            return false;
        }
        TagAndValue other = (TagAndValue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$tagName = this.getTagName();
        String other$tagName = other.getTagName();
        return !(this$tagName == null ? other$tagName != null : !this$tagName.equals(other$tagName));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TagAndValue;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $tagName = this.getTagName();
        result = result * 59 + ($tagName == null ? 43 : $tagName.hashCode());
        return result;
    }

    public static class NullTagPair
    extends TagAndValue<Void> {
        NullTagPair(String tagName) {
            super(tagName, null);
        }

        @Override
        protected BanyandbModel.TagValue buildTypedTagValue() {
            return BanyandbModel.TagValue.newBuilder().setNull(NullValue.NULL_VALUE).build();
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NullTagPair)) {
                return false;
            }
            NullTagPair other = (NullTagPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof NullTagPair;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    public static class BinaryTagPair
    extends TagAndValue<ByteString> {
        public BinaryTagPair(String fieldName, ByteString byteString) {
            super(fieldName, byteString);
        }

        @Override
        protected BanyandbModel.TagValue buildTypedTagValue() {
            return BanyandbModel.TagValue.newBuilder().setBinaryData((ByteString)this.value).build();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BinaryTagPair)) {
                return false;
            }
            BinaryTagPair other = (BinaryTagPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof BinaryTagPair;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    public static class LongArrayTagPair
    extends TagAndValue<List<Long>> {
        LongArrayTagPair(String tagName, List<Long> value) {
            super(tagName, value);
        }

        @Override
        protected BanyandbModel.TagValue buildTypedTagValue() {
            return BanyandbModel.TagValue.newBuilder().setIntArray(BanyandbModel.IntArray.newBuilder().addAllValue((Iterable)this.value).build()).build();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LongArrayTagPair)) {
                return false;
            }
            LongArrayTagPair other = (LongArrayTagPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof LongArrayTagPair;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    public static class LongTagPair
    extends TagAndValue<Long> {
        LongTagPair(String tagName, Long value) {
            super(tagName, value);
        }

        @Override
        protected BanyandbModel.TagValue buildTypedTagValue() {
            return BanyandbModel.TagValue.newBuilder().setInt(BanyandbModel.Int.newBuilder().setValue((Long)this.value).build()).build();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LongTagPair)) {
                return false;
            }
            LongTagPair other = (LongTagPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof LongTagPair;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    public static class StringArrayTagPair
    extends TagAndValue<List<String>> {
        StringArrayTagPair(String tagName, List<String> value) {
            super(tagName, value);
        }

        @Override
        protected BanyandbModel.TagValue buildTypedTagValue() {
            return BanyandbModel.TagValue.newBuilder().setStrArray(BanyandbModel.StrArray.newBuilder().addAllValue((Iterable)this.value).build()).build();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringArrayTagPair)) {
                return false;
            }
            StringArrayTagPair other = (StringArrayTagPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof StringArrayTagPair;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }

    public static class StringTagPair
    extends TagAndValue<String> {
        StringTagPair(String tagName, String value) {
            super(tagName, value);
        }

        @Override
        protected BanyandbModel.TagValue buildTypedTagValue() {
            return BanyandbModel.TagValue.newBuilder().setStr(BanyandbModel.Str.newBuilder().setValue((String)this.value).build()).build();
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringTagPair)) {
                return false;
            }
            StringTagPair other = (StringTagPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof StringTagPair;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            return result;
        }
    }
}

