/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.consul;

import com.google.common.base.Strings;
import com.orbitz.consul.AgentClient;
import com.orbitz.consul.Consul;
import com.orbitz.consul.HealthClient;
import com.orbitz.consul.model.agent.ImmutableRegistration;
import com.orbitz.consul.model.agent.Registration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterRegister;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.cluster.ServiceRegisterException;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.telemetry.api.TelemetryRelatedContext;

public class ConsulCoordinator
implements ClusterRegister,
ClusterNodesQuery {
    private final Consul client;
    private final String serviceName;
    private volatile Address selfAddress;

    public ConsulCoordinator(Consul client, String serviceName) {
        this.client = client;
        this.serviceName = serviceName;
    }

    public List<RemoteInstance> queryRemoteNodes() {
        HealthClient healthClient = this.client.healthClient();
        List nodes = (List)healthClient.getHealthyServiceInstances(this.serviceName).getResponse();
        ArrayList<RemoteInstance> remoteInstances = new ArrayList<RemoteInstance>();
        if (CollectionUtils.isNotEmpty((List)nodes)) {
            nodes.forEach(node -> {
                if (!Strings.isNullOrEmpty((String)node.getService().getAddress()) && Objects.nonNull(this.selfAddress)) {
                    if (this.selfAddress.getHost().equals(node.getService().getAddress()) && this.selfAddress.getPort() == node.getService().getPort()) {
                        remoteInstances.add(new RemoteInstance(new Address(node.getService().getAddress(), node.getService().getPort(), true)));
                    } else {
                        remoteInstances.add(new RemoteInstance(new Address(node.getService().getAddress(), node.getService().getPort(), false)));
                    }
                }
            });
        }
        return remoteInstances;
    }

    public void registerRemote(RemoteInstance remoteInstance) throws ServiceRegisterException {
        AgentClient agentClient = this.client.agentClient();
        this.selfAddress = remoteInstance.getAddress();
        TelemetryRelatedContext.INSTANCE.setId(this.selfAddress.toString());
        ImmutableRegistration registration = ImmutableRegistration.builder().id(remoteInstance.getAddress().toString()).name(this.serviceName).address(remoteInstance.getAddress().getHost()).port(remoteInstance.getAddress().getPort()).check(Registration.RegCheck.grpc((String)(remoteInstance.getAddress().getHost() + ":" + remoteInstance.getAddress().getPort()), (long)5L)).build();
        agentClient.register((Registration)registration);
    }
}

