/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.kubernetes;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.Event;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.ReusableWatch;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterRegister;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.cluster.ServiceRegisterException;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KubernetesCoordinator
implements ClusterRegister,
ClusterNodesQuery {
    private static final Logger logger = LoggerFactory.getLogger(KubernetesCoordinator.class);
    private final String uid;
    private final Map<String, RemoteInstance> cache = new ConcurrentHashMap<String, RemoteInstance>();
    private final ReusableWatch<Event> watch;
    private int port;

    KubernetesCoordinator(ReusableWatch<Event> watch, Supplier<String> uidSupplier) {
        this.watch = watch;
        this.uid = uidSupplier.get();
    }

    public void registerRemote(RemoteInstance remoteInstance) throws ServiceRegisterException {
        this.port = remoteInstance.getAddress().getPort();
        this.submitTask(MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Kubernetes-ApiServer-%s").build())));
    }

    private void submitTask(final ListeningExecutorService service) {
        this.watch.initOrReset();
        ListenableFuture watchFuture = service.submit(this.newWatch());
        Futures.addCallback((ListenableFuture)watchFuture, (FutureCallback)new FutureCallback<Object>(){

            public void onSuccess(@Nullable Object ignored) {
                KubernetesCoordinator.this.submitTask(service);
            }

            public void onFailure(@Nullable Throwable throwable) {
                logger.debug("Generate remote nodes error", throwable);
                KubernetesCoordinator.this.submitTask(service);
            }
        });
    }

    private Callable<Object> newWatch() {
        return () -> {
            this.generateRemoteNodes();
            return null;
        };
    }

    private void generateRemoteNodes() {
        Event event;
        Iterator iterator = this.watch.iterator();
        block9: while (iterator.hasNext() && (event = (Event)iterator.next()) != null) {
            logger.debug("Received event {} {}-{}", new Object[]{event.getType(), event.getUid(), event.getHost()});
            switch (event.getType()) {
                case "ADDED": 
                case "MODIFIED": {
                    this.cache.put(event.getUid(), new RemoteInstance(new Address(event.getHost(), this.port, event.getUid().equals(this.uid))));
                    continue block9;
                }
                case "DELETED": {
                    this.cache.remove(event.getUid());
                    continue block9;
                }
            }
            throw new RuntimeException(String.format("Unknown event %s", event.getType()));
        }
    }

    public List<RemoteInstance> queryRemoteNodes() {
        logger.debug("Query kubernetes remote nodes: {}", this.cache);
        return Lists.newArrayList(this.cache.values());
    }
}

