/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.kubernetes;

import io.kubernetes.client.informer.SharedIndexInformer;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.informer.cache.Lister;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.util.Config;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.ClusterModuleKubernetesConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NamespacedPodListInformer {
    INFORMER;

    @Generated
    private static final Logger log;
    private Lister<V1Pod> podLister;
    private SharedInformerFactory factory;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor(r -> {
        Thread thread = new Thread(r, "SKYWALKING_KUBERNETES_CLUSTER_INFORMER");
        thread.setDaemon(true);
        return thread;
    });

    private NamespacedPodListInformer() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (Objects.nonNull(this.factory)) {
                this.factory.stopAllRegisteredInformers();
            }
        }));
    }

    public synchronized void init(ClusterModuleKubernetesConfig podConfig) {
        try {
            this.doStartPodInformer(podConfig);
        }
        catch (IOException e) {
            log.error("cannot connect with api server in kubernetes", (Throwable)e);
        }
    }

    private void doStartPodInformer(ClusterModuleKubernetesConfig podConfig) throws IOException {
        ApiClient apiClient = Config.defaultClient();
        apiClient.setHttpClient(apiClient.getHttpClient().newBuilder().readTimeout(0L, TimeUnit.SECONDS).build());
        CoreV1Api coreV1Api = new CoreV1Api(apiClient);
        this.factory = new SharedInformerFactory(this.executorService);
        SharedIndexInformer podSharedIndexInformer = this.factory.sharedIndexInformerFor(params -> coreV1Api.listNamespacedPodCall(podConfig.getNamespace(), null, null, null, null, podConfig.getLabelSelector(), Integer.valueOf(Integer.MAX_VALUE), params.resourceVersion, Integer.valueOf(300), params.watch, null), V1Pod.class, V1PodList.class);
        this.factory.startAllRegisteredInformers();
        this.podLister = new Lister(podSharedIndexInformer.getIndexer());
    }

    public Optional<List<V1Pod>> listPods() {
        if (Objects.isNull(this.podLister)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.podLister.list().size() != 0 ? this.podLister.list().stream().filter(item -> "Running".equalsIgnoreCase(item.getStatus().getPhase())).collect(Collectors.toList()) : null);
    }

    static {
        log = LoggerFactory.getLogger(NamespacedPodListInformer.class);
    }
}

