/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.kubernetes;

import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.ClusterModuleKubernetesConfig;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.KubernetesCoordinator;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.NamespacedPodListInformer;
import org.apache.skywalking.oap.server.core.cluster.ClusterModule;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterRegister;
import org.apache.skywalking.oap.server.library.module.ModuleDefine;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;

public class ClusterModuleKubernetesProvider
extends ModuleProvider {
    private ClusterModuleKubernetesConfig config;
    private KubernetesCoordinator coordinator;

    public String name() {
        return "kubernetes";
    }

    public Class<? extends ModuleDefine> module() {
        return ClusterModule.class;
    }

    public ModuleProvider.ConfigCreator newConfigCreator() {
        return new ModuleProvider.ConfigCreator<ClusterModuleKubernetesConfig>(){

            public Class type() {
                return ClusterModuleKubernetesConfig.class;
            }

            public void onInitialized(ClusterModuleKubernetesConfig initialized) {
                ClusterModuleKubernetesProvider.this.config = initialized;
            }
        };
    }

    public void prepare() throws ServiceNotProvidedException {
        this.coordinator = new KubernetesCoordinator((ModuleDefineHolder)this.getManager(), this.config);
        this.registerServiceImplementation(ClusterRegister.class, (Service)this.coordinator);
        this.registerServiceImplementation(ClusterNodesQuery.class, (Service)this.coordinator);
    }

    public void start() {
        NamespacedPodListInformer.INFORMER.init(this.config);
    }

    public void notifyAfterCompleted() {
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

