/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.kubernetes;

import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientBuilder;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.informers.ResourceEventHandler;
import io.fabric8.kubernetes.client.informers.SharedIndexInformer;
import io.fabric8.kubernetes.client.informers.cache.Lister;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.cluster.plugin.kubernetes.ClusterModuleKubernetesConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum NamespacedPodListInformer {
    INFORMER;

    @Generated
    private static final Logger log;
    private Lister<Pod> podLister;

    public synchronized void init(ClusterModuleKubernetesConfig podConfig, ResourceEventHandler<Pod> eventHandler) {
        try {
            KubernetesClient kubernetesClient = new KubernetesClientBuilder().build();
            SharedIndexInformer informer = ((FilterWatchListDeletable)((NonNamespaceOperation)kubernetesClient.pods().inNamespace(podConfig.getNamespace())).withLabelSelector(podConfig.getLabelSelector())).inform(eventHandler);
            this.podLister = new Lister(informer.getIndexer());
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                informer.close();
                kubernetesClient.close();
            }));
        }
        catch (Exception e) {
            log.error("cannot connect with api server in kubernetes", (Throwable)e);
        }
    }

    public Optional<List<Pod>> listPods() {
        if (Objects.isNull(this.podLister)) {
            return Optional.empty();
        }
        return Optional.ofNullable(this.podLister.list().size() != 0 ? this.podLister.list().stream().filter(item -> "Running".equalsIgnoreCase(item.getStatus().getPhase())).collect(Collectors.toList()) : null);
    }

    static {
        log = LoggerFactory.getLogger(NamespacedPodListInformer.class);
    }
}

