/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.zookeeper;

import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.cluster.plugin.zookeeper.ClusterModuleZookeeperConfig;
import org.apache.skywalking.oap.server.cluster.plugin.zookeeper.SWInstanceSerializer;
import org.apache.skywalking.oap.server.cluster.plugin.zookeeper.ZookeeperCoordinator;
import org.apache.skywalking.oap.server.core.cluster.ClusterModule;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterRegister;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterModuleZookeeperProvider
extends ModuleProvider {
    private static final Logger logger = LoggerFactory.getLogger(ClusterModuleZookeeperProvider.class);
    private static final String BASE_PATH = "/skywalking";
    private final ClusterModuleZookeeperConfig config = new ClusterModuleZookeeperConfig();
    private CuratorFramework client;
    private ServiceDiscovery<RemoteInstance> serviceDiscovery;

    public String name() {
        return "zookeeper";
    }

    public Class module() {
        return ClusterModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(this.config.getBaseSleepTimeMs(), this.config.getMaxRetries());
        this.client = CuratorFrameworkFactory.newClient((String)this.config.getHostPort(), (RetryPolicy)retryPolicy);
        String path = BASE_PATH + (StringUtil.isEmpty((String)this.config.getNameSpace()) ? "" : "/" + this.config.getNameSpace());
        this.serviceDiscovery = ServiceDiscoveryBuilder.builder(RemoteInstance.class).client(this.client).basePath(path).watchInstances(true).serializer((InstanceSerializer)new SWInstanceSerializer()).build();
        try {
            this.client.start();
            this.client.blockUntilConnected();
            this.serviceDiscovery.start();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
        ZookeeperCoordinator coordinator = new ZookeeperCoordinator(this.serviceDiscovery);
        this.registerServiceImplementation(ClusterRegister.class, (Service)coordinator);
        this.registerServiceImplementation(ClusterNodesQuery.class, (Service)coordinator);
    }

    public void start() {
    }

    public void notifyAfterCompleted() {
    }

    public String[] requiredModules() {
        return new String[0];
    }
}

