/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.zookeeper;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.skywalking.oap.server.cluster.plugin.zookeeper.ClusterModuleZookeeperConfig;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterRegister;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.cluster.ServiceRegisterException;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.apache.skywalking.oap.server.telemetry.api.TelemetryRelatedContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperCoordinator
implements ClusterRegister,
ClusterNodesQuery {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperCoordinator.class);
    private final ClusterModuleZookeeperConfig config;
    private final ServiceDiscovery<RemoteInstance> serviceDiscovery;
    private volatile ServiceCache<RemoteInstance> serviceCache;
    private volatile Address selfAddress;

    ZookeeperCoordinator(ClusterModuleZookeeperConfig config, ServiceDiscovery<RemoteInstance> serviceDiscovery) {
        this.config = config;
        this.serviceDiscovery = serviceDiscovery;
    }

    public synchronized void registerRemote(RemoteInstance remoteInstance) throws ServiceRegisterException {
        try {
            String remoteNamePath = "remote";
            if (this.needUsingInternalAddr()) {
                remoteInstance = new RemoteInstance(new Address(this.config.getInternalComHost(), this.config.getInternalComPort(), true));
            }
            ServiceInstance thisInstance = ServiceInstance.builder().name(remoteNamePath).id(UUID.randomUUID().toString()).address(remoteInstance.getAddress().getHost()).port(remoteInstance.getAddress().getPort()).payload((Object)remoteInstance).build();
            this.serviceDiscovery.registerService(thisInstance);
            this.serviceCache = this.serviceDiscovery.serviceCacheBuilder().name(remoteNamePath).build();
            this.serviceCache.start();
            this.selfAddress = remoteInstance.getAddress();
            TelemetryRelatedContext.INSTANCE.setId(this.selfAddress.toString());
        }
        catch (Exception e) {
            throw new ServiceRegisterException(e.getMessage());
        }
    }

    public List<RemoteInstance> queryRemoteNodes() {
        ArrayList<RemoteInstance> remoteInstanceDetails = new ArrayList<RemoteInstance>(20);
        if (Objects.nonNull(this.serviceCache)) {
            List serviceInstances = this.serviceCache.getInstances();
            serviceInstances.forEach(serviceInstance -> {
                RemoteInstance instance = (RemoteInstance)serviceInstance.getPayload();
                if (instance.getAddress().equals((Object)this.selfAddress)) {
                    instance.getAddress().setSelf(true);
                } else {
                    instance.getAddress().setSelf(false);
                }
                remoteInstanceDetails.add(instance);
            });
        }
        return remoteInstanceDetails;
    }

    private boolean needUsingInternalAddr() {
        return !Strings.isNullOrEmpty((String)this.config.getInternalComHost()) && this.config.getInternalComPort() > 0;
    }
}

