/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.zookeeper;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.skywalking.oap.server.cluster.plugin.zookeeper.ClusterModuleZookeeperConfig;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterRegister;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.cluster.ServiceRegisterException;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZookeeperCoordinator
implements ClusterRegister,
ClusterNodesQuery {
    private static final Logger logger = LoggerFactory.getLogger(ZookeeperCoordinator.class);
    private static final String REMOTE_NAME_PATH = "remote";
    private final ClusterModuleZookeeperConfig config;
    private final ServiceDiscovery<RemoteInstance> serviceDiscovery;
    private final ServiceCache<RemoteInstance> serviceCache;
    private volatile Address selfAddress;

    ZookeeperCoordinator(ClusterModuleZookeeperConfig config, ServiceDiscovery<RemoteInstance> serviceDiscovery) throws Exception {
        this.config = config;
        this.serviceDiscovery = serviceDiscovery;
        this.serviceCache = serviceDiscovery.serviceCacheBuilder().name(REMOTE_NAME_PATH).build();
        this.serviceCache.start();
    }

    public synchronized void registerRemote(RemoteInstance remoteInstance) throws ServiceRegisterException {
        try {
            if (this.needUsingInternalAddr()) {
                remoteInstance = new RemoteInstance(new Address(this.config.getInternalComHost(), this.config.getInternalComPort(), true));
            }
            ServiceInstance thisInstance = ServiceInstance.builder().name(REMOTE_NAME_PATH).id(UUID.randomUUID().toString()).address(remoteInstance.getAddress().getHost()).port(remoteInstance.getAddress().getPort()).payload((Object)remoteInstance).build();
            this.serviceDiscovery.registerService(thisInstance);
            this.selfAddress = remoteInstance.getAddress();
        }
        catch (Exception e) {
            throw new ServiceRegisterException(e.getMessage());
        }
    }

    public List<RemoteInstance> queryRemoteNodes() {
        ArrayList<RemoteInstance> remoteInstanceDetails = new ArrayList<RemoteInstance>(20);
        List serviceInstances = this.serviceCache.getInstances();
        serviceInstances.forEach(serviceInstance -> {
            RemoteInstance instance = (RemoteInstance)serviceInstance.getPayload();
            if (instance.getAddress().equals((Object)this.selfAddress)) {
                instance.getAddress().setSelf(true);
            } else {
                instance.getAddress().setSelf(false);
            }
            remoteInstanceDetails.add(instance);
        });
        return remoteInstanceDetails;
    }

    private boolean needUsingInternalAddr() {
        return !Strings.isNullOrEmpty((String)this.config.getInternalComHost()) && this.config.getInternalComPort() > 0;
    }
}

