/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.zookeeper;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.curator.x.discovery.ServiceCache;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.skywalking.oap.server.cluster.plugin.zookeeper.ClusterModuleZookeeperConfig;
import org.apache.skywalking.oap.server.core.cluster.ClusterHealthStatus;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterRegister;
import org.apache.skywalking.oap.server.core.cluster.OAPNodeChecker;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.core.cluster.ServiceQueryException;
import org.apache.skywalking.oap.server.core.cluster.ServiceRegisterException;
import org.apache.skywalking.oap.server.core.remote.client.Address;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.telemetry.api.HealthCheckMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;

public class ZookeeperCoordinator
implements ClusterRegister,
ClusterNodesQuery {
    private static final String REMOTE_NAME_PATH = "remote";
    private final ModuleDefineHolder manager;
    private final ClusterModuleZookeeperConfig config;
    private final ServiceDiscovery<RemoteInstance> serviceDiscovery;
    private final ServiceCache<RemoteInstance> serviceCache;
    private volatile Address selfAddress;
    private HealthCheckMetrics healthChecker;

    ZookeeperCoordinator(ModuleDefineHolder manager, ClusterModuleZookeeperConfig config, ServiceDiscovery<RemoteInstance> serviceDiscovery) throws Exception {
        this.manager = manager;
        this.config = config;
        this.serviceDiscovery = serviceDiscovery;
        this.serviceCache = serviceDiscovery.serviceCacheBuilder().name(REMOTE_NAME_PATH).build();
        this.serviceCache.start();
    }

    public synchronized void registerRemote(RemoteInstance remoteInstance) throws ServiceRegisterException {
        try {
            this.initHealthChecker();
            if (this.needUsingInternalAddr()) {
                remoteInstance = new RemoteInstance(new Address(this.config.getInternalComHost(), this.config.getInternalComPort(), true));
            }
            ServiceInstance thisInstance = ServiceInstance.builder().name(REMOTE_NAME_PATH).id(UUID.randomUUID().toString()).address(remoteInstance.getAddress().getHost()).port(remoteInstance.getAddress().getPort()).payload((Object)remoteInstance).build();
            this.serviceDiscovery.registerService(thisInstance);
            this.selfAddress = remoteInstance.getAddress();
            this.healthChecker.health();
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw new ServiceRegisterException(e.getMessage());
        }
    }

    public List<RemoteInstance> queryRemoteNodes() {
        ArrayList<RemoteInstance> remoteInstances = new ArrayList<RemoteInstance>(20);
        try {
            this.initHealthChecker();
            List serviceInstances = this.serviceCache.getInstances();
            serviceInstances.forEach(serviceInstance -> {
                RemoteInstance instance = (RemoteInstance)serviceInstance.getPayload();
                if (instance.getAddress().equals((Object)this.selfAddress)) {
                    instance.getAddress().setSelf(true);
                } else {
                    instance.getAddress().setSelf(false);
                }
                remoteInstances.add(instance);
            });
            ClusterHealthStatus healthStatus = OAPNodeChecker.isHealth(remoteInstances);
            if (healthStatus.isHealth()) {
                this.healthChecker.health();
            } else {
                this.healthChecker.unHealth(healthStatus.getReason());
            }
        }
        catch (Throwable e) {
            this.healthChecker.unHealth(e);
            throw new ServiceQueryException(e.getMessage());
        }
        return remoteInstances;
    }

    private boolean needUsingInternalAddr() {
        return !Strings.isNullOrEmpty((String)this.config.getInternalComHost()) && this.config.getInternalComPort() > 0;
    }

    private void initHealthChecker() {
        if (this.healthChecker == null) {
            MetricsCreator metricCreator = (MetricsCreator)this.manager.find("telemetry").provider().getService(MetricsCreator.class);
            this.healthChecker = metricCreator.createHealthCheckerGauge("cluster_zookeeper", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        }
    }
}

