/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.cluster.plugin.zookeeper;

import com.google.common.collect.Lists;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceDiscoveryBuilder;
import org.apache.curator.x.discovery.details.InstanceSerializer;
import org.apache.skywalking.oap.server.cluster.plugin.zookeeper.ClusterModuleZookeeperConfig;
import org.apache.skywalking.oap.server.cluster.plugin.zookeeper.SWInstanceSerializer;
import org.apache.skywalking.oap.server.cluster.plugin.zookeeper.ZookeeperCoordinator;
import org.apache.skywalking.oap.server.core.cluster.ClusterModule;
import org.apache.skywalking.oap.server.core.cluster.ClusterNodesQuery;
import org.apache.skywalking.oap.server.core.cluster.ClusterRegister;
import org.apache.skywalking.oap.server.core.cluster.RemoteInstance;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleDefineHolder;
import org.apache.skywalking.oap.server.library.module.ModuleProvider;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.module.Service;
import org.apache.skywalking.oap.server.library.module.ServiceNotProvidedException;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.server.auth.DigestAuthenticationProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterModuleZookeeperProvider
extends ModuleProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterModuleZookeeperProvider.class);
    private static final String BASE_PATH = "/skywalking";
    private final ClusterModuleZookeeperConfig config = new ClusterModuleZookeeperConfig();
    private CuratorFramework client;
    private ServiceDiscovery<RemoteInstance> serviceDiscovery;
    private ZookeeperCoordinator coordinator;

    public String name() {
        return "zookeeper";
    }

    public Class module() {
        return ClusterModule.class;
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.config;
    }

    public void prepare() throws ServiceNotProvidedException, ModuleStartException {
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(this.config.getBaseSleepTimeMs(), this.config.getMaxRetries());
        CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder().retryPolicy((RetryPolicy)retryPolicy).connectString(this.config.getHostPort());
        if (this.config.isEnableACL()) {
            String authInfo = this.config.getExpression();
            if ("digest".equals(this.config.getSchema())) {
                try {
                    authInfo = DigestAuthenticationProvider.generateDigest((String)authInfo);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new ModuleStartException(e.getMessage(), (Throwable)e);
                }
            } else {
                throw new ModuleStartException("Support digest schema only.");
            }
            final ArrayList acls = Lists.newArrayList();
            acls.add(new ACL(31, new Id(this.config.getSchema(), authInfo)));
            acls.add(new ACL(1, ZooDefs.Ids.ANYONE_ID_UNSAFE));
            ACLProvider provider = new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return acls;
                }

                public List<ACL> getAclForPath(String s) {
                    return acls;
                }
            };
            builder.aclProvider(provider);
            builder.authorization(this.config.getSchema(), this.config.getExpression().getBytes());
        }
        this.client = builder.build();
        String path = BASE_PATH + (StringUtil.isEmpty((String)this.config.getNamespace()) ? "" : "/" + this.config.getNamespace());
        this.serviceDiscovery = ServiceDiscoveryBuilder.builder(RemoteInstance.class).client(this.client).basePath(path).watchInstances(true).serializer((InstanceSerializer)new SWInstanceSerializer()).build();
        try {
            this.client.start();
            this.client.blockUntilConnected();
            this.serviceDiscovery.start();
            this.coordinator = new ZookeeperCoordinator((ModuleDefineHolder)this.getManager(), this.config, this.serviceDiscovery);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
        this.registerServiceImplementation(ClusterRegister.class, (Service)this.coordinator);
        this.registerServiceImplementation(ClusterNodesQuery.class, (Service)this.coordinator);
    }

    public void start() {
    }

    public void notifyAfterCompleted() {
    }

    public String[] requiredModules() {
        return new String[]{"core"};
    }
}

