/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.apm.util.RunnableWithExceptionProtection;
import org.apache.skywalking.oap.server.configuration.api.ConfigChangeWatcher;
import org.apache.skywalking.oap.server.configuration.api.ConfigTable;
import org.apache.skywalking.oap.server.configuration.api.DynamicConfigurationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ConfigWatcherRegister
implements DynamicConfigurationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigWatcherRegister.class);
    public static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private Register register = new Register();
    private volatile boolean isStarted = false;
    private final long syncPeriod;

    public ConfigWatcherRegister() {
        this(60L);
    }

    public ConfigWatcherRegister(long syncPeriod) {
        this.syncPeriod = syncPeriod;
    }

    @Override
    public synchronized void registerConfigChangeWatcher(ConfigChangeWatcher watcher) {
        if (this.isStarted) {
            throw new IllegalStateException("Config Register has been started. Can't register new watcher.");
        }
        WatcherHolder holder = new WatcherHolder(watcher);
        if (this.register.containsKey(holder.getKey())) {
            throw new IllegalStateException("Duplicate register, watcher=" + watcher);
        }
        this.register.put(holder.getKey(), holder);
    }

    public void start() {
        this.isStarted = true;
        this.configSync();
        LOGGER.info("Current configurations after the bootstrap sync." + LINE_SEPARATOR + this.register.toString());
        Executors.newSingleThreadScheduledExecutor().scheduleAtFixedRate((Runnable)new RunnableWithExceptionProtection(this::configSync, t -> LOGGER.error("Sync config center error.", t)), this.syncPeriod, this.syncPeriod, TimeUnit.SECONDS);
    }

    void configSync() {
        Optional<ConfigTable> configTable = this.readConfig(this.register.keys());
        configTable.ifPresent(config -> {
            config.getItems().forEach(item -> {
                String itemName = item.getName();
                WatcherHolder holder = this.register.get(itemName);
                if (holder != null) {
                    ConfigChangeWatcher watcher = holder.getWatcher();
                    String newItemValue = item.getValue();
                    if (newItemValue == null) {
                        if (watcher.value() != null) {
                            watcher.notify(new ConfigChangeWatcher.ConfigChangeEvent(null, ConfigChangeWatcher.EventType.DELETE));
                        }
                    } else if (!newItemValue.equals(watcher.value())) {
                        watcher.notify(new ConfigChangeWatcher.ConfigChangeEvent(newItemValue, ConfigChangeWatcher.EventType.MODIFY));
                    }
                } else {
                    LOGGER.warn("Config {} from configuration center, doesn't match any watcher, ignore.", (Object)itemName);
                }
            });
            LOGGER.trace("Current configurations after the sync." + LINE_SEPARATOR + this.register.toString());
        });
    }

    public abstract Optional<ConfigTable> readConfig(Set<String> var1);

    private class WatcherHolder {
        private ConfigChangeWatcher watcher;
        private final String key;

        public WatcherHolder(ConfigChangeWatcher watcher) {
            this.watcher = watcher;
            this.key = String.join((CharSequence)".", watcher.getModule(), watcher.getProvider().name(), watcher.getItemName());
        }

        @Generated
        public ConfigChangeWatcher getWatcher() {
            return this.watcher;
        }

        @Generated
        public String getKey() {
            return this.key;
        }
    }

    public class Register {
        private Map<String, WatcherHolder> register = new HashMap<String, WatcherHolder>();

        private boolean containsKey(String key) {
            return this.register.containsKey(key);
        }

        private void put(String key, WatcherHolder holder) {
            this.register.put(key, holder);
        }

        public WatcherHolder get(String name) {
            return this.register.get(name);
        }

        public Set<String> keys() {
            return this.register.keySet();
        }

        public String toString() {
            StringBuilder registerTableDescription = new StringBuilder();
            registerTableDescription.append("Following dynamic config items are available.").append(LINE_SEPARATOR);
            registerTableDescription.append("---------------------------------------------").append(LINE_SEPARATOR);
            this.register.forEach((key, holder) -> {
                ConfigChangeWatcher watcher = holder.getWatcher();
                registerTableDescription.append("key:").append((String)key).append("    module:").append(watcher.getModule()).append("    provider:").append(watcher.getProvider().name()).append("    value(current):").append(watcher.value()).append(LINE_SEPARATOR);
            });
            return registerTableDescription.toString();
        }
    }
}

