/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.zookeeper;

import com.google.common.base.Strings;
import org.apache.skywalking.oap.server.configuration.api.AbstractConfigurationProvider;
import org.apache.skywalking.oap.server.configuration.api.ConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.zookeeper.ZookeeperConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.zookeeper.ZookeeperServerSettings;
import org.apache.skywalking.oap.server.library.module.ModuleConfig;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;

public class ZookeeperConfigurationProvider
extends AbstractConfigurationProvider {
    private ZookeeperServerSettings settings = new ZookeeperServerSettings();

    public String name() {
        return "zookeeper";
    }

    public ModuleConfig createConfigBeanIfAbsent() {
        return this.settings;
    }

    protected ConfigWatcherRegister initConfigReader() throws ModuleStartException {
        if (Strings.isNullOrEmpty((String)this.settings.getHostPort())) {
            throw new ModuleStartException("Zookeeper hostPort cannot be null or empty.");
        }
        if (Strings.isNullOrEmpty((String)this.settings.getNameSpace())) {
            throw new ModuleStartException("Zookeeper nameSpace cannot be null or empty.");
        }
        try {
            return new ZookeeperConfigWatcherRegister(this.settings);
        }
        catch (Exception e) {
            throw new ModuleStartException(e.getMessage(), (Throwable)e);
        }
    }
}

