/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.configuration.zookeeper;

import java.util.Optional;
import java.util.Set;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.skywalking.oap.server.configuration.api.ConfigTable;
import org.apache.skywalking.oap.server.configuration.api.ConfigWatcherRegister;
import org.apache.skywalking.oap.server.configuration.zookeeper.ZookeeperServerSettings;

public class ZookeeperConfigWatcherRegister
extends ConfigWatcherRegister {
    private final PathChildrenCache childrenCache;
    private final String prefix;

    public ZookeeperConfigWatcherRegister(ZookeeperServerSettings settings) throws Exception {
        super((long)settings.getPeriod());
        this.prefix = settings.getNameSpace() + "/";
        ExponentialBackoffRetry retryPolicy = new ExponentialBackoffRetry(settings.getBaseSleepTimeMs(), settings.getMaxRetries());
        CuratorFramework client = CuratorFrameworkFactory.newClient((String)settings.getHostPort(), (RetryPolicy)retryPolicy);
        client.start();
        this.childrenCache = new PathChildrenCache(client, settings.getNameSpace(), true);
        this.childrenCache.start();
    }

    public Optional<ConfigTable> readConfig(Set<String> keys) {
        ConfigTable table = new ConfigTable();
        keys.forEach(s -> {
            ChildData data = this.childrenCache.getCurrentData(this.prefix + s);
            table.add(new ConfigTable.ConfigItem(s, data == null ? null : new String(data.getData())));
        });
        return Optional.of(table);
    }
}

