/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy;

import io.envoyproxy.envoy.api.v2.core.Node;
import io.envoyproxy.envoy.service.metrics.v2.MetricsServiceGrpc;
import io.envoyproxy.envoy.service.metrics.v2.StreamMetricsMessage;
import io.envoyproxy.envoy.service.metrics.v2.StreamMetricsResponse;
import io.grpc.stub.StreamObserver;
import io.prometheus.client.Metrics;
import java.util.List;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.register.service.IServiceInstanceInventoryRegister;
import org.apache.skywalking.oap.server.core.register.service.IServiceInventoryRegister;
import org.apache.skywalking.oap.server.core.source.EnvoyInstanceMetric;
import org.apache.skywalking.oap.server.core.source.Source;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.TimeBucketUtils;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetric;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetric;
import org.apache.skywalking.oap.server.telemetry.api.MetricCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricServiceGRPCHandler
extends MetricsServiceGrpc.MetricsServiceImplBase {
    private static final Logger logger = LoggerFactory.getLogger(MetricServiceGRPCHandler.class);
    private final IServiceInventoryRegister serviceInventoryRegister;
    private final IServiceInstanceInventoryRegister serviceInstanceInventoryRegister;
    private final SourceReceiver sourceReceiver;
    private CounterMetric counter;
    private HistogramMetric histogram;

    public MetricServiceGRPCHandler(ModuleManager moduleManager) {
        this.serviceInventoryRegister = (IServiceInventoryRegister)moduleManager.find("core").provider().getService(IServiceInventoryRegister.class);
        this.serviceInstanceInventoryRegister = (IServiceInstanceInventoryRegister)moduleManager.find("core").provider().getService(IServiceInstanceInventoryRegister.class);
        this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
        MetricCreator metricCreator = (MetricCreator)moduleManager.find("telemetry").provider().getService(MetricCreator.class);
        this.counter = metricCreator.createCounter("envoy_metric_in_count", "The count of envoy service metric received", MetricTag.EMPTY_KEY, MetricTag.EMPTY_VALUE);
        this.histogram = metricCreator.createHistogramMetric("envoy_metric_in_latency", "The process latency of service metric receiver", MetricTag.EMPTY_KEY, MetricTag.EMPTY_VALUE, new double[0]);
    }

    public StreamObserver<StreamMetricsMessage> streamMetrics(final StreamObserver<StreamMetricsResponse> responseObserver) {
        return new StreamObserver<StreamMetricsMessage>(){
            private volatile boolean isFirst = true;
            private String serviceName = null;
            private int serviceId = 0;
            private String serviceInstanceName = null;
            private int serviceInstanceId = 0;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onNext(StreamMetricsMessage message) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Received msg {}", (Object)message);
                }
                if (this.isFirst) {
                    this.isFirst = false;
                    StreamMetricsMessage.Identifier identifier = message.getIdentifier();
                    Node node = identifier.getNode();
                    if (node != null) {
                        String cluster;
                        String nodeId = node.getId();
                        if (!StringUtil.isEmpty((String)nodeId)) {
                            this.serviceInstanceName = nodeId;
                        }
                        if (!StringUtil.isEmpty((String)(cluster = node.getCluster()))) {
                            this.serviceName = cluster;
                            if (this.serviceInstanceName == null) {
                                this.serviceInstanceName = this.serviceName;
                            }
                        }
                    }
                    if (this.serviceName == null) {
                        this.serviceName = this.serviceInstanceName;
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("Envoy metric reported from service[{}], service instance[{}]", (Object)this.serviceName, (Object)this.serviceInstanceName);
                }
                if (this.serviceInstanceId == 0) {
                    if (this.serviceName == null || this.serviceInstanceName == null) return;
                    if (this.serviceId == 0) {
                        logger.debug("Register envoy service [{}].", (Object)this.serviceName);
                        this.serviceId = MetricServiceGRPCHandler.this.serviceInventoryRegister.getOrCreate(this.serviceName, null);
                    }
                    if (this.serviceId == 0) return;
                    logger.debug("Register envoy service instance [{}].", (Object)this.serviceInstanceName);
                    this.serviceInstanceId = MetricServiceGRPCHandler.this.serviceInstanceInventoryRegister.getOrCreate(this.serviceId, this.serviceInstanceName, this.serviceInstanceName, System.currentTimeMillis(), null);
                    return;
                }
                List list = message.getEnvoyMetricsList();
                boolean needHeartbeatUpdate = true;
                block7: for (int i = 0; i < list.size(); ++i) {
                    MetricServiceGRPCHandler.this.counter.inc();
                    HistogramMetric.Timer timer = MetricServiceGRPCHandler.this.histogram.createTimer();
                    try {
                        Metrics.MetricFamily metricFamily = (Metrics.MetricFamily)list.get(i);
                        double value = 0.0;
                        long timestamp = 0L;
                        switch (metricFamily.getType()) {
                            case GAUGE: {
                                for (Metrics.Metric metric : metricFamily.getMetricList()) {
                                    timestamp = metric.getTimestampMs();
                                    value = metric.getGauge().getValue();
                                    if (timestamp > 1000000000000000000L) {
                                        timestamp /= 1000000L;
                                    }
                                    EnvoyInstanceMetric metricSource = new EnvoyInstanceMetric();
                                    metricSource.setServiceId(this.serviceId);
                                    metricSource.setServiceName(this.serviceName);
                                    metricSource.setId(this.serviceInstanceId);
                                    metricSource.setName(this.serviceInstanceName);
                                    metricSource.setMetricName(metricFamily.getName());
                                    metricSource.setValue(value);
                                    metricSource.setTimeBucket(TimeBucketUtils.INSTANCE.getMinuteTimeBucket(timestamp));
                                    MetricServiceGRPCHandler.this.sourceReceiver.receive((Source)metricSource);
                                }
                                break;
                            }
                            default: {
                                continue block7;
                            }
                        }
                        if (!needHeartbeatUpdate) continue;
                        MetricServiceGRPCHandler.this.serviceInventoryRegister.heartbeat(this.serviceId, timestamp);
                        MetricServiceGRPCHandler.this.serviceInstanceInventoryRegister.heartbeat(this.serviceInstanceId, timestamp);
                        needHeartbeatUpdate = false;
                        continue;
                    }
                    finally {
                        timer.finish();
                    }
                }
            }

            public void onError(Throwable throwable) {
                logger.error("Error in receiving metric from envoy", throwable);
                responseObserver.onCompleted();
            }

            public void onCompleted() {
                responseObserver.onNext((Object)StreamMetricsResponse.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }
}

