/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy;

import io.envoyproxy.envoy.api.v2.core.Node;
import io.envoyproxy.envoy.service.metrics.v2.MetricsServiceGrpc;
import io.envoyproxy.envoy.service.metrics.v2.StreamMetricsMessage;
import io.envoyproxy.envoy.service.metrics.v2.StreamMetricsResponse;
import io.grpc.stub.StreamObserver;
import io.prometheus.client.Metrics;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.analysis.NodeType;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.source.EnvoyInstanceMetric;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceUpdate;
import org.apache.skywalking.oap.server.core.source.Source;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricServiceGRPCHandler
extends MetricsServiceGrpc.MetricsServiceImplBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricServiceGRPCHandler.class);
    private final SourceReceiver sourceReceiver;
    private CounterMetrics counter;
    private HistogramMetrics histogram;

    public MetricServiceGRPCHandler(ModuleManager moduleManager) {
        this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.counter = metricsCreator.createCounter("envoy_metric_in_count", "The count of envoy service metrics received", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.histogram = metricsCreator.createHistogramMetric("envoy_metric_in_latency", "The process latency of service metrics receiver", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE, new double[0]);
    }

    public StreamObserver<StreamMetricsMessage> streamMetrics(final StreamObserver<StreamMetricsResponse> responseObserver) {
        return new StreamObserver<StreamMetricsMessage>(){
            private volatile boolean isFirst = true;
            private String serviceName = null;
            private String serviceInstanceName = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void onNext(StreamMetricsMessage message) {
                if (log.isDebugEnabled()) {
                    log.debug("Received msg {}", (Object)message);
                }
                if (this.isFirst) {
                    this.isFirst = false;
                    StreamMetricsMessage.Identifier identifier = message.getIdentifier();
                    Node node = identifier.getNode();
                    if (node != null) {
                        String cluster;
                        String nodeId = node.getId();
                        if (!StringUtil.isEmpty((String)nodeId)) {
                            this.serviceInstanceName = nodeId;
                        }
                        if (!StringUtil.isEmpty((String)(cluster = node.getCluster()))) {
                            this.serviceName = cluster;
                            if (this.serviceInstanceName == null) {
                                this.serviceInstanceName = this.serviceName;
                            }
                        }
                    }
                    if (this.serviceName == null) {
                        this.serviceName = this.serviceInstanceName;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Envoy metrics reported from service[{}], service instance[{}]", (Object)this.serviceName, (Object)this.serviceInstanceName);
                }
                if (StringUtil.isNotEmpty((String)this.serviceName) && StringUtil.isNotEmpty((String)this.serviceInstanceName)) {
                    List list = message.getEnvoyMetricsList();
                    boolean needHeartbeatUpdate = true;
                    block7: for (int i = 0; i < list.size(); ++i) {
                        MetricServiceGRPCHandler.this.counter.inc();
                        String serviceId = IDManager.ServiceID.buildId((String)this.serviceName, (NodeType)NodeType.Normal);
                        String serviceInstanceId = IDManager.ServiceInstanceID.buildId((String)serviceId, (String)this.serviceInstanceName);
                        HistogramMetrics.Timer timer = MetricServiceGRPCHandler.this.histogram.createTimer();
                        try {
                            Metrics.MetricFamily metricFamily = (Metrics.MetricFamily)list.get(i);
                            double value = 0.0;
                            long timestamp = 0L;
                            switch (metricFamily.getType()) {
                                case GAUGE: {
                                    for (Metrics.Metric metrics : metricFamily.getMetricList()) {
                                        timestamp = metrics.getTimestampMs();
                                        value = metrics.getGauge().getValue();
                                        if (timestamp > 1000000000000000000L) {
                                            timestamp /= 1000000L;
                                        }
                                        EnvoyInstanceMetric metricSource = new EnvoyInstanceMetric();
                                        metricSource.setServiceId(serviceId);
                                        metricSource.setServiceName(this.serviceName);
                                        metricSource.setId(serviceInstanceId);
                                        metricSource.setName(this.serviceInstanceName);
                                        metricSource.setMetricName(metricFamily.getName());
                                        metricSource.setValue(value);
                                        metricSource.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)timestamp));
                                        MetricServiceGRPCHandler.this.sourceReceiver.receive((Source)metricSource);
                                    }
                                    break;
                                }
                                default: {
                                    continue block7;
                                }
                            }
                            if (!needHeartbeatUpdate) continue;
                            ServiceInstanceUpdate serviceInstanceUpdate = new ServiceInstanceUpdate();
                            serviceInstanceUpdate.setName(this.serviceInstanceName);
                            serviceInstanceUpdate.setServiceId(serviceId);
                            serviceInstanceUpdate.setTimeBucket(TimeBucket.getMinuteTimeBucket((long)timestamp));
                            MetricServiceGRPCHandler.this.sourceReceiver.receive((Source)serviceInstanceUpdate);
                            needHeartbeatUpdate = false;
                            continue;
                        }
                        finally {
                            timer.finish();
                        }
                    }
                }
            }

            public void onError(Throwable throwable) {
                log.error("Error in receiving metrics from envoy", throwable);
                responseObserver.onCompleted();
            }

            public void onCompleted() {
                responseObserver.onNext((Object)StreamMetricsResponse.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }
}

