/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.mx;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.util.ResourceUtils;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public enum FieldsHelper {
    SINGLETON;

    @Generated
    private static final Logger log;
    private boolean initialized = false;
    private Map<String, ServiceNameFormat> fieldNameMapping;
    private Map<String, Method> fieldSetterMapping;

    public void init(String file) throws Exception {
        this.init(ResourceUtils.readToStream((String)file), ServiceMetaInfo.class);
    }

    public void init(String file, Class<? extends ServiceMetaInfo> serviceInfoClass) throws Exception {
        this.init(ResourceUtils.readToStream((String)file), serviceInfoClass);
    }

    public void init(InputStream inputStream, Class<? extends ServiceMetaInfo> serviceInfoClass) throws ModuleStartException {
        if (this.initialized) {
            return;
        }
        Yaml yaml = new Yaml();
        Map config = (Map)yaml.load(inputStream);
        this.fieldNameMapping = new HashMap<String, ServiceNameFormat>(config.size());
        this.fieldSetterMapping = new HashMap<String, Method>(config.size());
        for (Map.Entry entry : config.entrySet()) {
            String serviceMetaInfoFieldName = (String)entry.getKey();
            String flatBuffersFieldName = (String)entry.getValue();
            Pattern p = Pattern.compile("(\\$\\{(?<property>.+?)})");
            Matcher m = p.matcher(flatBuffersFieldName);
            ArrayList<List<String>> flatBuffersFieldNames = new ArrayList<List<String>>(m.groupCount());
            StringBuffer serviceNamePattern = new StringBuffer();
            while (m.find()) {
                String property = m.group("property");
                flatBuffersFieldNames.add(Splitter.on((char)'.').omitEmptyStrings().splitToList((CharSequence)property));
                m.appendReplacement(serviceNamePattern, "%s");
            }
            this.fieldNameMapping.put(serviceMetaInfoFieldName, new ServiceNameFormat(serviceNamePattern.toString(), flatBuffersFieldNames));
            try {
                Method setterMethod = serviceInfoClass.getMethod("set" + StringUtils.capitalize((String)serviceMetaInfoFieldName), String.class);
                setterMethod.setAccessible(true);
                this.fieldSetterMapping.put(serviceMetaInfoFieldName, setterMethod);
            }
            catch (NoSuchMethodException e) {
                throw new ModuleStartException("Initialize method error", (Throwable)e);
            }
        }
        this.initialized = true;
    }

    public void inflate(Struct metadata, ServiceMetaInfo serviceMetaInfo) throws Exception {
        Value empty = Value.newBuilder().setStringValue("-").build();
        Value root = Value.newBuilder().setStructValue(metadata).build();
        for (Map.Entry<String, ServiceNameFormat> entry : this.fieldNameMapping.entrySet()) {
            ServiceNameFormat serviceNameFormat = entry.getValue();
            Object[] values = new String[serviceNameFormat.properties.size()];
            for (int i = 0; i < serviceNameFormat.properties.size(); ++i) {
                List properties = (List)serviceNameFormat.properties.get(i);
                Value value = root;
                for (String property : properties) {
                    value = value.getStructValue().getFieldsOrDefault(property, empty);
                }
                values[i] = value.getStringValue();
            }
            this.fieldSetterMapping.get(entry.getKey()).invoke((Object)serviceMetaInfo, Strings.lenientFormat((String)serviceNameFormat.format, (Object[])values));
        }
    }

    static {
        log = LoggerFactory.getLogger(FieldsHelper.class);
    }

    private static class ServiceNameFormat {
        private final String format;
        private final List<List<String>> properties;

        @Generated
        public ServiceNameFormat(String format, List<List<String>> properties) {
            this.format = format;
            this.properties = properties;
        }
    }
}

