/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.k8s;

import io.envoyproxy.envoy.config.core.v3.Address;
import io.envoyproxy.envoy.config.core.v3.SocketAddress;
import io.envoyproxy.envoy.data.accesslog.v3.AccessLogCommon;
import io.envoyproxy.envoy.data.accesslog.v3.HTTPAccessLogEntry;
import io.envoyproxy.envoy.service.accesslog.v3.StreamAccessLogsMessage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetric;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.AbstractALSAnalyzer;
import org.apache.skywalking.oap.server.receiver.envoy.als.Role;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.apache.skywalking.oap.server.receiver.envoy.als.k8s.K8SServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sALSServiceMeshHTTPAnalysis
extends AbstractALSAnalyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8sALSServiceMeshHTTPAnalysis.class);
    protected K8SServiceRegistry serviceRegistry;

    @Override
    public String name() {
        return "k8s-mesh";
    }

    @Override
    public void init(ModuleManager manager, EnvoyMetricReceiverConfig config) {
        this.serviceRegistry = new K8SServiceRegistry(config);
        this.serviceRegistry.start();
    }

    @Override
    public List<ServiceMeshMetric.Builder> analysis(List<ServiceMeshMetric.Builder> result, StreamAccessLogsMessage.Identifier identifier, HTTPAccessLogEntry entry, Role role) {
        if (CollectionUtils.isNotEmpty(result)) {
            return result;
        }
        if (this.serviceRegistry.isEmpty()) {
            return Collections.emptyList();
        }
        switch (role) {
            case PROXY: {
                return this.analyzeProxy(entry);
            }
            case SIDECAR: {
                return this.analyzeSideCar(entry);
            }
        }
        return Collections.emptyList();
    }

    protected List<ServiceMeshMetric.Builder> analyzeSideCar(HTTPAccessLogEntry entry) {
        AccessLogCommon properties = entry.getCommonProperties();
        if (properties == null) {
            return Collections.emptyList();
        }
        String cluster = properties.getUpstreamCluster();
        if (cluster == null) {
            return Collections.emptyList();
        }
        ArrayList<ServiceMeshMetric.Builder> sources = new ArrayList<ServiceMeshMetric.Builder>();
        Address downstreamRemoteAddress = properties.hasDownstreamDirectRemoteAddress() ? properties.getDownstreamDirectRemoteAddress() : properties.getDownstreamRemoteAddress();
        ServiceMetaInfo downstreamService = this.find(downstreamRemoteAddress.getSocketAddress().getAddress());
        Address downstreamLocalAddress = properties.getDownstreamLocalAddress();
        ServiceMetaInfo localService = this.find(downstreamLocalAddress.getSocketAddress().getAddress());
        if (cluster.startsWith("inbound|")) {
            ServiceMeshMetric.Builder metrics;
            if (downstreamService.equals(ServiceMetaInfo.UNKNOWN)) {
                metrics = this.newAdapter(entry, null, localService).adaptToDownstreamMetrics();
                log.debug("Transformed ingress->sidecar inbound mesh metrics {}", (Object)metrics);
            } else {
                metrics = this.newAdapter(entry, downstreamService, localService).adaptToDownstreamMetrics();
                log.debug("Transformed sidecar->sidecar(server side) inbound mesh metrics {}", (Object)metrics);
            }
            sources.add(metrics);
        } else if (cluster.startsWith("outbound|")) {
            Address upstreamRemoteAddress = properties.getUpstreamRemoteAddress();
            ServiceMetaInfo destService = this.find(upstreamRemoteAddress.getSocketAddress().getAddress());
            ServiceMeshMetric.Builder metric = this.newAdapter(entry, downstreamService, destService).adaptToUpstreamMetrics();
            log.debug("Transformed sidecar->sidecar(server side) inbound mesh metric {}", (Object)metric);
            sources.add(metric);
        }
        return sources;
    }

    protected List<ServiceMeshMetric.Builder> analyzeProxy(HTTPAccessLogEntry entry) {
        AccessLogCommon properties = entry.getCommonProperties();
        if (properties == null) {
            return Collections.emptyList();
        }
        Address downstreamLocalAddress = properties.getDownstreamLocalAddress();
        Address downstreamRemoteAddress = properties.hasDownstreamDirectRemoteAddress() ? properties.getDownstreamDirectRemoteAddress() : properties.getDownstreamRemoteAddress();
        Address upstreamRemoteAddress = properties.getUpstreamRemoteAddress();
        if (downstreamLocalAddress == null || downstreamRemoteAddress == null || upstreamRemoteAddress == null) {
            return Collections.emptyList();
        }
        ArrayList<ServiceMeshMetric.Builder> result = new ArrayList<ServiceMeshMetric.Builder>(2);
        SocketAddress downstreamRemoteAddressSocketAddress = downstreamRemoteAddress.getSocketAddress();
        ServiceMetaInfo outside = this.find(downstreamRemoteAddressSocketAddress.getAddress());
        SocketAddress downstreamLocalAddressSocketAddress = downstreamLocalAddress.getSocketAddress();
        ServiceMetaInfo ingress = this.find(downstreamLocalAddressSocketAddress.getAddress());
        ServiceMeshMetric.Builder metric = this.newAdapter(entry, outside, ingress).adaptToDownstreamMetrics();
        log.debug("Transformed ingress inbound mesh metric {}", (Object)metric);
        result.add(metric);
        SocketAddress upstreamRemoteAddressSocketAddress = upstreamRemoteAddress.getSocketAddress();
        ServiceMetaInfo targetService = this.find(upstreamRemoteAddressSocketAddress.getAddress());
        ServiceMeshMetric.Builder outboundMetric = this.newAdapter(entry, ingress, targetService).adaptToUpstreamMetrics().setTlsMode("NONE");
        log.debug("Transformed ingress outbound mesh metric {}", (Object)outboundMetric);
        result.add(outboundMetric);
        return result;
    }

    protected ServiceMetaInfo find(String ip) {
        return this.serviceRegistry.findService(ip);
    }
}

