/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.k8s;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

public class ServiceNameFormatter {
    private final List<String> properties;
    private final StringBuffer serviceNamePattern;

    public ServiceNameFormatter(String rule) {
        rule = (String)StringUtils.defaultIfBlank((CharSequence)rule, (CharSequence)"${pod.metadata.labels.(service.istio.io/canonical-name)}");
        this.properties = new ArrayList<String>();
        this.serviceNamePattern = new StringBuffer();
        Pattern variablePattern = Pattern.compile("(\\$\\{(?<property>.+?)})");
        Matcher matcher = variablePattern.matcher(rule);
        while (matcher.find()) {
            this.properties.add(matcher.group("property"));
            matcher.appendReplacement(this.serviceNamePattern, "%s");
        }
    }

    public String format(Map<String, Object> context) throws Exception {
        Object[] values = new Object[this.properties.size()];
        for (int i = 0; i < this.properties.size(); ++i) {
            Object value;
            values[i] = value = PropertyUtils.getProperty(context, (String)this.properties.get(i));
        }
        return Strings.lenientFormat((String)this.serviceNamePattern.toString(), (Object[])values);
    }
}

