/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.mx;

import Wasm.Common.FlatNode;
import Wasm.Common.KeyVal;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.protobuf.Any;
import com.google.protobuf.ByteString;
import com.google.protobuf.BytesValue;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Objects;
import lombok.Generated;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.apache.skywalking.oap.server.receiver.envoy.als.mx.FieldsHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceMetaInfoAdapter
extends ServiceMetaInfo {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ServiceMetaInfoAdapter.class);

    public ServiceMetaInfoAdapter(ByteString bv) throws Exception {
        ByteBuffer buffer = ByteBuffer.wrap(BytesValue.parseFrom((ByteString)bv).getValue().toByteArray());
        FlatNode flatNode = FlatNode.getRootAsFlatNode((ByteBuffer)buffer);
        if (log.isDebugEnabled()) {
            for (int i = 0; i < flatNode.labelsLength(); ++i) {
                KeyVal kv = flatNode.labels(i);
                if (!Objects.nonNull(kv)) continue;
                log.debug("wasm label: {} : {}", (Object)kv.key(), (Object)kv.value());
            }
        }
        Struct metadata = Objects.requireNonNull(ServiceMetaInfoAdapter.extractStructFromNodeFlatBuffer(flatNode));
        FieldsHelper.SINGLETON.inflate(metadata, this);
    }

    public ServiceMetaInfoAdapter(Any any) throws Exception {
        this(any.getValue());
    }

    public static Struct extractStructFromNodeFlatBuffer(FlatNode node) {
        Struct.Builder builder = Struct.newBuilder();
        builder.putFields("NAME", Value.newBuilder().setStringValue(Strings.nullToEmpty((String)node.name())).build());
        builder.putFields("NAMESPACE", Value.newBuilder().setStringValue(Strings.nullToEmpty((String)node.namespace())).build());
        builder.putFields("OWNER", Value.newBuilder().setStringValue(Strings.nullToEmpty((String)node.owner())).build());
        builder.putFields("WORKLOAD_NAME", Value.newBuilder().setStringValue(Strings.nullToEmpty((String)node.workloadName())).build());
        builder.putFields("ISTIO_VERSION", Value.newBuilder().setStringValue(Strings.nullToEmpty((String)node.istioVersion())).build());
        builder.putFields("MESH_ID", Value.newBuilder().setStringValue(Strings.nullToEmpty((String)node.meshId())).build());
        builder.putFields("CLUSTER_ID", Value.newBuilder().setStringValue(Strings.nullToEmpty((String)node.clusterId())).build());
        Struct.Builder labels = Struct.newBuilder();
        for (int i = 0; i < node.labelsLength(); ++i) {
            KeyVal label = node.labels(i);
            labels.putFields(Strings.nullToEmpty((String)label.key()), Value.newBuilder().setStringValue(Strings.nullToEmpty((String)label.value())).build());
        }
        builder.putFields("LABELS", Value.newBuilder().setStructValue(labels).build());
        Struct.Builder platformMetadata = Struct.newBuilder();
        for (int i = 0; i < node.platformMetadataLength(); ++i) {
            KeyVal platformMd = node.platformMetadata(i);
            platformMetadata.putFields(Strings.nullToEmpty((String)platformMd.key()), Value.newBuilder().setStringValue(Strings.nullToEmpty((String)platformMd.value())).build());
        }
        builder.putFields("PLATFORM_METADATA", Value.newBuilder().setStructValue(platformMetadata).build());
        ArrayList<String> appContainers = new ArrayList<String>();
        for (int i = 0; i < node.appContainersLength(); ++i) {
            appContainers.add(node.appContainers(i));
        }
        builder.putFields("APP_CONTAINERS", Value.newBuilder().setStringValue(Joiner.on((String)",").join(appContainers)).build());
        return builder.build();
    }

    public ServiceMetaInfoAdapter(Struct metadata) throws Exception {
        FieldsHelper.SINGLETON.inflate(Objects.requireNonNull(metadata), this);
    }

    @Generated
    public ServiceMetaInfoAdapter() {
    }
}

