/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.persistence;

import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import io.envoyproxy.envoy.data.accesslog.v3.HTTPAccessLogEntry;
import io.envoyproxy.envoy.service.accesslog.v3.StreamAccessLogsMessage;
import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.DetectPoint;
import org.apache.skywalking.apm.network.logging.v3.JSONLog;
import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.apm.network.logging.v3.LogDataBody;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetric;
import org.apache.skywalking.oap.log.analyzer.provider.log.ILogAnalyzerService;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.library.util.ProtoBufJsonUtils;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.ALSHTTPAnalysis;
import org.apache.skywalking.oap.server.receiver.envoy.als.Role;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogsPersistence
implements ALSHTTPAnalysis {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogsPersistence.class);
    private ILogAnalyzerService logAnalyzerService;

    @Override
    public String name() {
        return "persistence";
    }

    @Override
    public void init(ModuleManager manager, EnvoyMetricReceiverConfig config) throws ModuleStartException {
        this.logAnalyzerService = (ILogAnalyzerService)manager.find("log-analyzer").provider().getService(ILogAnalyzerService.class);
    }

    @Override
    public List<ServiceMeshMetric.Builder> analysis(List<ServiceMeshMetric.Builder> result, StreamAccessLogsMessage.Identifier identifier, HTTPAccessLogEntry entry, Role role) {
        try {
            result.stream().findFirst().ifPresent(metrics -> {
                try {
                    LogData logData = this.convertToLogData(entry, (ServiceMeshMetric.Builder)metrics);
                    this.logAnalyzerService.doAnalysis(logData);
                }
                catch (IOException e) {
                    log.error("Failed to parse error log entry to log data: {}", (Object)TextFormat.shortDebugString((MessageOrBuilder)entry), (Object)e);
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to persist Envoy access log", (Throwable)e);
        }
        return result;
    }

    @Override
    public Role identify(StreamAccessLogsMessage.Identifier alsIdentifier, Role prev) {
        return prev;
    }

    public LogData convertToLogData(HTTPAccessLogEntry logEntry, ServiceMeshMetric.Builder metrics) throws IOException {
        boolean isServerSide = metrics.getDetectPoint() == DetectPoint.server;
        String svc = isServerSide ? metrics.getDestServiceName() : metrics.getSourceServiceName();
        String svcInst = isServerSide ? metrics.getDestServiceInstance() : metrics.getSourceServiceInstance();
        return LogData.newBuilder().setService(svc).setServiceInstance(svcInst).setEndpoint(metrics.getEndpoint()).setTimestamp(metrics.getEndTime()).setBody(LogDataBody.newBuilder().setJson(JSONLog.newBuilder().setJson(ProtoBufJsonUtils.toJSON((Message)logEntry)))).build();
    }
}

