/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.k8s;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

public class ServiceNameFormatter {
    private final List<String> properties;
    private final StringBuffer serviceNamePattern;

    public ServiceNameFormatter(String rule) {
        rule = (String)StringUtils.defaultIfBlank((CharSequence)rule, (CharSequence)"${pod.metadata.labels.(service.istio.io/canonical-name),pod.metadata.labels.(app.kubernetes.io/name),pod.metadata.labels.app)}");
        this.properties = new ArrayList<String>();
        this.serviceNamePattern = new StringBuffer();
        Pattern variablePattern = Pattern.compile("(\\$\\{(?<property>.+?)})");
        Matcher matcher = variablePattern.matcher(rule);
        while (matcher.find()) {
            this.properties.add(matcher.group("property"));
            matcher.appendReplacement(this.serviceNamePattern, "%s");
        }
    }

    public String format(Map<String, Object> context) throws Exception {
        Object[] values = new Object[this.properties.size()];
        for (int i = 0; i < this.properties.size(); ++i) {
            Object value;
            String property = this.properties.get(i);
            values[i] = value = Stream.of(property.split(",")).map(it -> {
                try {
                    return PropertyUtils.getProperty((Object)context, (String)it);
                }
                catch (Exception e) {
                    return null;
                }
            }).filter(it -> Objects.nonNull(it) && !Strings.isNullOrEmpty((String)it.toString())).findFirst().orElse("-");
        }
        return Strings.lenientFormat((String)this.serviceNamePattern.toString(), (Object[])values);
    }
}

