/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy;

import io.envoyproxy.envoy.service.metrics.v2.MetricsServiceGrpc;
import io.envoyproxy.envoy.service.metrics.v3.StreamMetricsMessage;
import io.envoyproxy.envoy.service.metrics.v3.StreamMetricsResponse;
import io.grpc.stub.StreamObserver;
import io.prometheus.client.Metrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.meter.analyzer.prometheus.PrometheusMetricConverter;
import org.apache.skywalking.oap.server.core.analysis.meter.MeterSystem;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.apache.skywalking.oap.server.receiver.envoy.metrics.adapters.ProtoMetricFamily2MetricsAdapter;
import org.apache.skywalking.oap.server.telemetry.api.CounterMetrics;
import org.apache.skywalking.oap.server.telemetry.api.HistogramMetrics;
import org.apache.skywalking.oap.server.telemetry.api.MetricsCreator;
import org.apache.skywalking.oap.server.telemetry.api.MetricsTag;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricServiceGRPCHandler
extends MetricsServiceGrpc.MetricsServiceImplBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MetricServiceGRPCHandler.class);
    private final CounterMetrics counter;
    private final HistogramMetrics histogram;
    private final List<PrometheusMetricConverter> converters;
    private final EnvoyMetricReceiverConfig config;

    public MetricServiceGRPCHandler(ModuleManager moduleManager, EnvoyMetricReceiverConfig config) throws ModuleStartException {
        this.config = config;
        MetricsCreator metricsCreator = (MetricsCreator)moduleManager.find("telemetry").provider().getService(MetricsCreator.class);
        this.counter = metricsCreator.createCounter("envoy_metric_in_count", "The count of envoy service metrics received", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE);
        this.histogram = metricsCreator.createHistogramMetric("envoy_metric_in_latency", "The process latency of service metrics receiver", MetricsTag.EMPTY_KEY, MetricsTag.EMPTY_VALUE, new double[0]);
        MeterSystem meterSystem = (MeterSystem)moduleManager.find("core").provider().getService(MeterSystem.class);
        this.converters = config.rules().stream().map(rule -> new PrometheusMetricConverter(rule, meterSystem)).collect(Collectors.toList());
    }

    public StreamObserver<StreamMetricsMessage> streamMetrics(final StreamObserver<StreamMetricsResponse> responseObserver) {
        return new StreamObserver<StreamMetricsMessage>(){
            private volatile boolean isFirst = true;
            private ServiceMetaInfo service;

            public void onNext(StreamMetricsMessage message) {
                block16: {
                    if (log.isDebugEnabled()) {
                        log.debug("Received msg {}", (Object)message);
                    }
                    if (this.isFirst) {
                        this.isFirst = false;
                        this.service = MetricServiceGRPCHandler.this.config.serviceMetaInfoFactory().fromStruct(message.getIdentifier().getNode().getMetadata());
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Envoy metrics reported from service[{}]", (Object)this.service);
                    }
                    if (this.service == null || !StringUtil.isNotEmpty((String)this.service.getServiceName()) || !StringUtil.isNotEmpty((String)this.service.getServiceInstanceName())) break block16;
                    List list = message.getEnvoyMetricsList();
                    HashMap<String, List> groupingMetrics = new HashMap<String, List>();
                    for (Metrics.MetricFamily metricFamily : list) {
                        MetricServiceGRPCHandler.this.counter.inc();
                        HistogramMetrics.Timer ignored = MetricServiceGRPCHandler.this.histogram.createTimer();
                        Throwable throwable = null;
                        try {
                            ProtoMetricFamily2MetricsAdapter adapter = new ProtoMetricFamily2MetricsAdapter(metricFamily, MetricServiceGRPCHandler.this.config.getClusterManagerMetricsAdapter());
                            adapter.adapt().forEach(it -> {
                                it.getLabels().putIfAbsent("app", this.service.getServiceName());
                                it.getLabels().putIfAbsent("instance", this.service.getServiceInstanceName());
                                List metricList = groupingMetrics.computeIfAbsent(it.getName(), name -> new ArrayList());
                                metricList.add(it);
                            });
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (ignored == null) continue;
                            if (throwable != null) {
                                try {
                                    ignored.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            ignored.close();
                        }
                    }
                    groupingMetrics.forEach((name, metrics) -> MetricServiceGRPCHandler.this.converters.forEach(converter -> converter.toMeter(metrics.stream())));
                }
            }

            public void onError(Throwable throwable) {
                log.error("Error in receiving metrics from envoy", throwable);
                responseObserver.onCompleted();
            }

            public void onCompleted() {
                responseObserver.onNext((Object)StreamMetricsResponse.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }
}

