/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.tcp;

import io.envoyproxy.envoy.data.accesslog.v3.AccessLogCommon;
import io.envoyproxy.envoy.data.accesslog.v3.ConnectionProperties;
import io.envoyproxy.envoy.data.accesslog.v3.TCPAccessLogEntry;
import java.util.Optional;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.DetectPoint;
import org.apache.skywalking.apm.network.servicemesh.v3.Protocol;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetric;
import org.apache.skywalking.apm.network.servicemesh.v3.TCPInfo;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oap.server.receiver.envoy.als.LogEntry2MetricsAdapter;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;

public class TCPLogEntry2MetricsAdapter {
    protected final TCPAccessLogEntry entry;
    protected final ServiceMetaInfo sourceService;
    protected final ServiceMetaInfo targetService;

    public ServiceMeshMetric.Builder adaptToDownstreamMetrics() {
        AccessLogCommon properties = this.entry.getCommonProperties();
        long startTime = LogEntry2MetricsAdapter.formatAsLong(properties.getStartTime());
        long duration = LogEntry2MetricsAdapter.formatAsLong(properties.getTimeToLastDownstreamTxByte());
        return this.adaptCommonPart().setStartTime(startTime).setEndTime(startTime + duration).setLatency((int)Math.max(1L, duration)).setDetectPoint(DetectPoint.server);
    }

    public ServiceMeshMetric.Builder adaptToUpstreamMetrics() {
        AccessLogCommon properties = this.entry.getCommonProperties();
        long startTime = LogEntry2MetricsAdapter.formatAsLong(properties.getStartTime());
        long outboundStartTime = startTime + LogEntry2MetricsAdapter.formatAsLong(properties.getTimeToFirstUpstreamTxByte());
        long outboundEndTime = startTime + LogEntry2MetricsAdapter.formatAsLong(properties.getTimeToLastUpstreamRxByte());
        return this.adaptCommonPart().setStartTime(outboundStartTime).setEndTime(outboundEndTime).setLatency((int)Math.max(1L, outboundEndTime - outboundStartTime)).setDetectPoint(DetectPoint.client);
    }

    public ServiceMeshMetric.Builder adaptCommonPart() {
        AccessLogCommon properties = this.entry.getCommonProperties();
        ConnectionProperties connectionProperties = this.entry.getConnectionProperties();
        String tlsMode = LogEntry2MetricsAdapter.parseTLS(properties.getTlsProperties());
        String internalErrorCode = LogEntry2MetricsAdapter.parseInternalErrorCode(properties.getResponseFlags());
        ServiceMeshMetric.Builder builder = ServiceMeshMetric.newBuilder().setTlsMode(tlsMode).setProtocol(Protocol.TCP).setStatus(StringUtil.isBlank((String)internalErrorCode)).setTcp(TCPInfo.newBuilder().setReceivedBytes(connectionProperties.getReceivedBytes()).setSentBytes(connectionProperties.getSentBytes())).setInternalErrorCode(internalErrorCode);
        Optional.ofNullable(this.sourceService).map(ServiceMetaInfo::getServiceName).ifPresent(arg_0 -> ((ServiceMeshMetric.Builder)builder).setSourceServiceName(arg_0));
        Optional.ofNullable(this.sourceService).map(ServiceMetaInfo::getServiceInstanceName).ifPresent(arg_0 -> ((ServiceMeshMetric.Builder)builder).setSourceServiceInstance(arg_0));
        Optional.ofNullable(this.targetService).map(ServiceMetaInfo::getServiceName).ifPresent(arg_0 -> ((ServiceMeshMetric.Builder)builder).setDestServiceName(arg_0));
        Optional.ofNullable(this.targetService).map(ServiceMetaInfo::getServiceInstanceName).ifPresent(arg_0 -> ((ServiceMeshMetric.Builder)builder).setDestServiceInstance(arg_0));
        return builder;
    }

    @Generated
    public TCPLogEntry2MetricsAdapter(TCPAccessLogEntry entry, ServiceMetaInfo sourceService, ServiceMetaInfo targetService) {
        this.entry = entry;
        this.sourceService = sourceService;
        this.targetService = targetService;
    }
}

