/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als;

import io.envoyproxy.envoy.config.core.v3.Node;
import io.envoyproxy.envoy.service.accesslog.v3.StreamAccessLogsMessage;
import java.util.List;
import lombok.Generated;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetric;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.Role;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;

public interface AccessLogAnalyzer<E> {
    public String name();

    public void init(ModuleManager var1, EnvoyMetricReceiverConfig var2) throws ModuleStartException;

    public Result analysis(Result var1, StreamAccessLogsMessage.Identifier var2, E var3, Role var4);

    default public Role identify(StreamAccessLogsMessage.Identifier alsIdentifier, Role defaultRole) {
        if (alsIdentifier == null) {
            return defaultRole;
        }
        if (!alsIdentifier.hasNode()) {
            return defaultRole;
        }
        Node node = alsIdentifier.getNode();
        String id = node.getId();
        if (id.startsWith("router~")) {
            return Role.PROXY;
        }
        if (id.startsWith("sidecar~")) {
            return Role.SIDECAR;
        }
        return defaultRole;
    }

    public static class Result {
        private ServiceMetaInfo service;
        private List<ServiceMeshMetric.Builder> metrics;

        @Generated
        Result(ServiceMetaInfo service, List<ServiceMeshMetric.Builder> metrics) {
            this.service = service;
            this.metrics = metrics;
        }

        @Generated
        public static ResultBuilder builder() {
            return new ResultBuilder();
        }

        @Generated
        public ServiceMetaInfo getService() {
            return this.service;
        }

        @Generated
        public List<ServiceMeshMetric.Builder> getMetrics() {
            return this.metrics;
        }

        @Generated
        public void setService(ServiceMetaInfo service) {
            this.service = service;
        }

        @Generated
        public void setMetrics(List<ServiceMeshMetric.Builder> metrics) {
            this.metrics = metrics;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Result)) {
                return false;
            }
            Result other = (Result)o;
            if (!other.canEqual(this)) {
                return false;
            }
            ServiceMetaInfo this$service = this.getService();
            ServiceMetaInfo other$service = other.getService();
            if (this$service == null ? other$service != null : !((Object)this$service).equals(other$service)) {
                return false;
            }
            List<ServiceMeshMetric.Builder> this$metrics = this.getMetrics();
            List<ServiceMeshMetric.Builder> other$metrics = other.getMetrics();
            return !(this$metrics == null ? other$metrics != null : !((Object)this$metrics).equals(other$metrics));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Result;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            ServiceMetaInfo $service = this.getService();
            result = result * 59 + ($service == null ? 43 : ((Object)$service).hashCode());
            List<ServiceMeshMetric.Builder> $metrics = this.getMetrics();
            result = result * 59 + ($metrics == null ? 43 : ((Object)$metrics).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AccessLogAnalyzer.Result(service=" + this.getService() + ", metrics=" + this.getMetrics() + ")";
        }

        @Generated
        public static class ResultBuilder {
            @Generated
            private ServiceMetaInfo service;
            @Generated
            private List<ServiceMeshMetric.Builder> metrics;

            @Generated
            ResultBuilder() {
            }

            @Generated
            public ResultBuilder service(ServiceMetaInfo service) {
                this.service = service;
                return this;
            }

            @Generated
            public ResultBuilder metrics(List<ServiceMeshMetric.Builder> metrics) {
                this.metrics = metrics;
                return this;
            }

            @Generated
            public Result build() {
                return new Result(this.service, this.metrics);
            }

            @Generated
            public String toString() {
                return "AccessLogAnalyzer.Result.ResultBuilder(service=" + this.service + ", metrics=" + this.metrics + ")";
            }
        }
    }
}

