/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.k8s;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.kubernetes.client.informer.ResourceEventHandler;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Endpoints;
import io.kubernetes.client.openapi.models.V1EndpointsList;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1PodList;
import io.kubernetes.client.openapi.models.V1Service;
import io.kubernetes.client.openapi.models.V1ServiceList;
import io.kubernetes.client.util.Config;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.apache.skywalking.oap.server.receiver.envoy.als.k8s.KubernetesNodeRegistry;
import org.apache.skywalking.oap.server.receiver.envoy.als.k8s.ServiceNameFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8SServiceRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8SServiceRegistry.class);
    protected final Map<String, ServiceMetaInfo> ipServiceMetaInfoMap;
    protected final Map<String, V1Service> idServiceMap;
    protected final Map<String, V1Pod> ipPodMap;
    protected final Map<String, String> ipServiceMap;
    protected final ExecutorService executor;
    protected final ServiceNameFormatter serviceNameFormatter;
    private final EnvoyMetricReceiverConfig config;
    private final KubernetesNodeRegistry nodeRegistry;

    public K8SServiceRegistry(EnvoyMetricReceiverConfig config) {
        this.config = config;
        this.serviceNameFormatter = new ServiceNameFormatter(config.getK8sServiceNameRule());
        this.ipServiceMetaInfoMap = new ConcurrentHashMap<String, ServiceMetaInfo>();
        this.idServiceMap = new ConcurrentHashMap<String, V1Service>();
        this.ipPodMap = new ConcurrentHashMap<String, V1Pod>();
        this.ipServiceMap = new ConcurrentHashMap<String, String>();
        this.executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("K8SServiceRegistry-%d").setDaemon(true).build());
        this.nodeRegistry = new KubernetesNodeRegistry();
    }

    public void start() throws IOException {
        ApiClient apiClient = Config.defaultClient();
        apiClient.setHttpClient(apiClient.getHttpClient().newBuilder().readTimeout(0L, TimeUnit.SECONDS).build());
        Configuration.setDefaultApiClient((ApiClient)apiClient);
        CoreV1Api coreV1Api = new CoreV1Api();
        SharedInformerFactory factory = new SharedInformerFactory(this.executor);
        this.listenServiceEvents(coreV1Api, factory);
        this.listenEndpointsEvents(coreV1Api, factory);
        this.listenPodEvents(coreV1Api, factory);
        factory.startAllRegisteredInformers();
        this.nodeRegistry.start();
    }

    private void listenServiceEvents(CoreV1Api coreV1Api, SharedInformerFactory factory) {
        factory.sharedIndexInformerFor(params -> coreV1Api.listServiceForAllNamespacesCall(null, null, null, null, null, null, params.resourceVersion, null, params.timeoutSeconds, params.watch, null), V1Service.class, V1ServiceList.class).addEventHandler((ResourceEventHandler)new ResourceEventHandler<V1Service>(){

            public void onAdd(V1Service service) {
                K8SServiceRegistry.this.addService(service);
            }

            public void onUpdate(V1Service oldService, V1Service newService) {
                K8SServiceRegistry.this.addService(newService);
            }

            public void onDelete(V1Service service, boolean deletedFinalStateUnknown) {
                K8SServiceRegistry.this.removeService(service);
            }
        });
    }

    private void listenEndpointsEvents(CoreV1Api coreV1Api, SharedInformerFactory factory) {
        factory.sharedIndexInformerFor(params -> coreV1Api.listEndpointsForAllNamespacesCall(null, null, null, null, null, null, params.resourceVersion, null, params.timeoutSeconds, params.watch, null), V1Endpoints.class, V1EndpointsList.class).addEventHandler((ResourceEventHandler)new ResourceEventHandler<V1Endpoints>(){

            public void onAdd(V1Endpoints endpoints) {
                K8SServiceRegistry.this.addEndpoints(endpoints);
            }

            public void onUpdate(V1Endpoints oldEndpoints, V1Endpoints newEndpoints) {
                K8SServiceRegistry.this.addEndpoints(newEndpoints);
            }

            public void onDelete(V1Endpoints endpoints, boolean deletedFinalStateUnknown) {
                K8SServiceRegistry.this.removeEndpoints(endpoints);
            }
        });
    }

    private void listenPodEvents(CoreV1Api coreV1Api, SharedInformerFactory factory) {
        factory.sharedIndexInformerFor(params -> coreV1Api.listPodForAllNamespacesCall(null, null, null, null, null, null, params.resourceVersion, null, params.timeoutSeconds, params.watch, null), V1Pod.class, V1PodList.class).addEventHandler((ResourceEventHandler)new ResourceEventHandler<V1Pod>(){

            public void onAdd(V1Pod pod) {
                K8SServiceRegistry.this.addPod(pod);
            }

            public void onUpdate(V1Pod oldPod, V1Pod newPod) {
                K8SServiceRegistry.this.addPod(newPod);
            }

            public void onDelete(V1Pod pod, boolean deletedFinalStateUnknown) {
                K8SServiceRegistry.this.removePod(pod);
            }
        });
    }

    protected void addService(V1Service service) {
        Optional.ofNullable(service.getMetadata()).ifPresent(metadata -> this.idServiceMap.put(metadata.getNamespace() + ":" + metadata.getName(), service));
        this.recompose();
    }

    protected void removeService(V1Service service) {
        Optional.ofNullable(service.getMetadata()).ifPresent(metadata -> this.idServiceMap.remove(metadata.getNamespace() + ":" + metadata.getName()));
    }

    protected void addPod(V1Pod pod) {
        Optional.ofNullable(pod.getStatus()).flatMap(status -> Optional.ofNullable(status.getPodIP())).ifPresent(podIP -> this.ipPodMap.put((String)podIP, pod));
        this.recompose();
    }

    protected void removePod(V1Pod pod) {
        Optional.ofNullable(pod.getStatus()).flatMap(status -> Optional.ofNullable(status.getPodIP())).ifPresent(this.ipPodMap::remove);
    }

    protected void addEndpoints(V1Endpoints endpoints) {
        V1ObjectMeta endpointsMetadata = endpoints.getMetadata();
        if (Objects.isNull(endpointsMetadata)) {
            log.error("Endpoints metadata is null: {}", (Object)endpoints);
            return;
        }
        String namespace = endpointsMetadata.getNamespace();
        String name = endpointsMetadata.getName();
        Optional.ofNullable(endpoints.getSubsets()).ifPresent(subsets -> subsets.forEach(subset -> Optional.ofNullable(subset.getAddresses()).ifPresent(addresses -> addresses.forEach(address -> Optional.ofNullable(address.getIp()).ifPresent(ip -> this.ipServiceMap.put((String)ip, namespace + ":" + name))))));
        this.recompose();
    }

    protected void removeEndpoints(V1Endpoints endpoints) {
        Optional.ofNullable(endpoints.getSubsets()).ifPresent(subsets -> subsets.forEach(subset -> Optional.ofNullable(subset.getAddresses()).ifPresent(addresses -> addresses.forEach(address -> Optional.ofNullable(address.getIp()).ifPresent(this.ipServiceMap::remove)))));
    }

    protected List<ServiceMetaInfo.KeyValue> transformLabelsToTags(Map<String, String> labels) {
        if (Objects.isNull(labels)) {
            return Collections.emptyList();
        }
        return labels.entrySet().stream().map(each -> new ServiceMetaInfo.KeyValue((String)each.getKey(), (String)each.getValue())).collect(Collectors.toList());
    }

    public ServiceMetaInfo findService(String ip) {
        if (this.nodeRegistry.isNode(ip)) {
            return this.config.serviceMetaInfoFactory().unknown();
        }
        ServiceMetaInfo service = this.ipServiceMetaInfoMap.get(ip);
        if (Objects.isNull(service)) {
            log.debug("Unknown ip {}, ip -> service is null", (Object)ip);
            return this.config.serviceMetaInfoFactory().unknown();
        }
        return service;
    }

    protected void recompose() {
        this.ipPodMap.forEach((ip, pod) -> {
            V1Service service;
            String namespaceService = this.ipServiceMap.get(ip);
            if (Strings.isNullOrEmpty((String)namespaceService) || Objects.isNull(service = this.idServiceMap.get(namespaceService))) {
                return;
            }
            ImmutableMap context = ImmutableMap.of((Object)"service", (Object)service, (Object)"pod", (Object)pod);
            V1ObjectMeta podMetadata = pod.getMetadata();
            if (Objects.isNull(podMetadata)) {
                log.warn("Pod metadata is null, {}", pod);
                return;
            }
            this.ipServiceMetaInfoMap.computeIfAbsent((String)ip, arg_0 -> this.lambda$null$18((Map)context, service, podMetadata, arg_0));
        });
    }

    public boolean isEmpty() {
        return this.ipServiceMetaInfoMap.isEmpty();
    }

    private /* synthetic */ ServiceMetaInfo lambda$null$18(Map context, V1Service service, V1ObjectMeta podMetadata, String unused) {
        ServiceMetaInfo serviceMetaInfo = new ServiceMetaInfo();
        try {
            serviceMetaInfo.setServiceName(this.serviceNameFormatter.format(context));
        }
        catch (Exception e) {
            log.error("Failed to evaluate service name.", (Throwable)e);
            V1ObjectMeta serviceMetadata = service.getMetadata();
            if (Objects.isNull(serviceMetadata)) {
                log.warn("Service metadata is null, {}", (Object)service);
                return this.config.serviceMetaInfoFactory().unknown();
            }
            serviceMetaInfo.setServiceName(serviceMetadata.getName());
        }
        serviceMetaInfo.setServiceInstanceName(String.format("%s.%s", podMetadata.getName(), podMetadata.getNamespace()));
        serviceMetaInfo.setTags(this.transformLabelsToTags(podMetadata.getLabels()));
        return serviceMetaInfo;
    }
}

