/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.k8s;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.kubernetes.client.informer.ResourceEventHandler;
import io.kubernetes.client.informer.SharedInformerFactory;
import io.kubernetes.client.openapi.ApiClient;
import io.kubernetes.client.openapi.Configuration;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeAddress;
import io.kubernetes.client.openapi.models.V1NodeList;
import io.kubernetes.client.openapi.models.V1NodeStatus;
import io.kubernetes.client.util.Config;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import lombok.Generated;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KubernetesNodeRegistry
implements ResourceEventHandler<V1Node> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KubernetesNodeRegistry.class);
    private final Set<String> nodeIPs = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("KubernetesNodeRegistry-%d").setDaemon(true).build());

    public void start() throws IOException {
        ApiClient apiClient = Config.defaultClient();
        apiClient.setHttpClient(apiClient.getHttpClient().newBuilder().readTimeout(0L, TimeUnit.SECONDS).build());
        Configuration.setDefaultApiClient((ApiClient)apiClient);
        CoreV1Api coreV1Api = new CoreV1Api();
        SharedInformerFactory factory = new SharedInformerFactory(this.executor);
        this.listenNodeEvents(coreV1Api, factory);
        factory.startAllRegisteredInformers();
    }

    private void listenNodeEvents(CoreV1Api coreV1Api, SharedInformerFactory factory) {
        factory.sharedIndexInformerFor(params -> coreV1Api.listNodeCall(null, null, null, null, null, null, params.resourceVersion, null, params.timeoutSeconds, params.watch, null), V1Node.class, V1NodeList.class).addEventHandler((ResourceEventHandler)this);
    }

    public void onAdd(V1Node node) {
        this.forEachAddress(node, this.nodeIPs::add);
    }

    public void onUpdate(V1Node oldNode, V1Node newNode) {
        this.onAdd(newNode);
    }

    public void onDelete(V1Node node, boolean deletedFinalStateUnknown) {
        this.forEachAddress(node, this.nodeIPs::remove);
    }

    public void forEachAddress(V1Node node, Consumer<String> consume) {
        Optional.ofNullable(node).map(V1Node::getStatus).map(V1NodeStatus::getAddresses).ifPresent(addresses -> addresses.stream().map(V1NodeAddress::getAddress).filter(StringUtil::isNotBlank).forEach(consume));
    }

    public boolean isNode(String ip) {
        return this.nodeIPs.contains(ip);
    }
}

