/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.persistence;

import com.google.protobuf.Message;
import io.envoyproxy.envoy.data.accesslog.v3.TCPAccessLogEntry;
import io.envoyproxy.envoy.service.accesslog.v3.StreamAccessLogsMessage;
import lombok.Generated;
import org.apache.skywalking.apm.network.logging.v3.LogData;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetric;
import org.apache.skywalking.oap.log.analyzer.provider.log.ILogAnalyzerService;
import org.apache.skywalking.oap.server.core.analysis.Layer;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.module.ModuleStartException;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.AccessLogAnalyzer;
import org.apache.skywalking.oap.server.receiver.envoy.als.Role;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.apache.skywalking.oap.server.receiver.envoy.als.tcp.TCPAccessLogAnalyzer;
import org.apache.skywalking.oap.server.receiver.envoy.als.tcp.TCPLogEntry2MetricsAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TCPLogsPersistence
implements TCPAccessLogAnalyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TCPLogsPersistence.class);
    private ILogAnalyzerService logAnalyzerService;

    @Override
    public String name() {
        return "persistence";
    }

    @Override
    public void init(ModuleManager manager, EnvoyMetricReceiverConfig config) throws ModuleStartException {
        this.logAnalyzerService = (ILogAnalyzerService)manager.find("log-analyzer").provider().getService(ILogAnalyzerService.class);
    }

    @Override
    public AccessLogAnalyzer.Result analysis(AccessLogAnalyzer.Result result, StreamAccessLogsMessage.Identifier identifier, TCPAccessLogEntry entry, Role role) {
        try {
            if (result.getService() == null) {
                return result;
            }
            LogData logData = this.convertToLogData(entry, result);
            this.logAnalyzerService.doAnalysis(logData, (Message)entry);
        }
        catch (Exception e) {
            log.error("Failed to persist Envoy access log", (Throwable)e);
        }
        return result;
    }

    @Override
    public Role identify(StreamAccessLogsMessage.Identifier alsIdentifier, Role prev) {
        return prev;
    }

    public LogData convertToLogData(TCPAccessLogEntry logEntry, AccessLogAnalyzer.Result result) {
        ServiceMetaInfo service = result.getService();
        ServiceMeshMetric.Builder metrics = new TCPLogEntry2MetricsAdapter(logEntry, null, null).adaptCommonPart();
        return LogData.newBuilder().setService(service.getServiceName()).setServiceInstance(service.getServiceInstanceName()).setTimestamp(metrics.getEndTime()).setLayer(Layer.MESH.name()).build();
    }
}

