/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.k8s;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import io.kubernetes.client.openapi.ApiException;
import io.kubernetes.client.openapi.apis.CoreV1Api;
import io.kubernetes.client.openapi.models.V1Node;
import io.kubernetes.client.openapi.models.V1NodeAddress;
import io.kubernetes.client.openapi.models.V1NodeStatus;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import io.kubernetes.client.openapi.models.V1Pod;
import io.kubernetes.client.openapi.models.V1Service;
import io.vavr.Tuple2;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.library.kubernetes.KubernetesClient;
import org.apache.skywalking.library.kubernetes.KubernetesEndpoints;
import org.apache.skywalking.library.kubernetes.KubernetesPods;
import org.apache.skywalking.library.kubernetes.KubernetesServices;
import org.apache.skywalking.library.kubernetes.ObjectID;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.apache.skywalking.oap.server.receiver.envoy.als.k8s.ServiceNameFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8SServiceRegistry {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8SServiceRegistry.class);
    protected final EnvoyMetricReceiverConfig config;
    protected final ServiceNameFormatter serviceNameFormatter;
    protected final LoadingCache<K8SServiceRegistry, Set<String>> nodeIPs;
    protected final LoadingCache<String, ServiceMetaInfo> ipServiceMetaInfoMap;

    public K8SServiceRegistry(final EnvoyMetricReceiverConfig config) {
        this.config = config;
        this.serviceNameFormatter = new ServiceNameFormatter(config.getK8sServiceNameRule());
        KubernetesClient.setDefault();
        CoreV1Api coreV1Api = new CoreV1Api();
        CacheBuilder cacheBuilder = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(3L));
        this.nodeIPs = cacheBuilder.build(CacheLoader.from(() -> {
            try {
                return coreV1Api.listNode(null, null, null, null, null, null, null, null, null, null).getItems().stream().map(V1Node::getStatus).map(V1NodeStatus::getAddresses).flatMap(it -> it.stream().map(V1NodeAddress::getAddress).filter(StringUtil::isNotBlank)).collect(Collectors.toSet());
            }
            catch (ApiException e) {
                log.error("Failed to list Nodes.", (Throwable)e);
                return Collections.emptySet();
            }
        }));
        this.ipServiceMetaInfoMap = cacheBuilder.build((CacheLoader)new CacheLoader<String, ServiceMetaInfo>(){

            public ServiceMetaInfo load(String ip) throws Exception {
                Optional pod = KubernetesPods.INSTANCE.findByIP(ip);
                if (!pod.isPresent()) {
                    log.debug("No corresponding Pod for IP: {}", (Object)ip);
                    return config.serviceMetaInfoFactory().unknown();
                }
                Optional<ObjectID> serviceID = KubernetesEndpoints.INSTANCE.list().stream().filter(endpoints -> endpoints.getMetadata() != null).filter(endpoints -> endpoints.getSubsets() != null).map(endpoints -> {
                    V1ObjectMeta metadata = endpoints.getMetadata();
                    if (endpoints.getSubsets().stream().filter(subset -> subset.getAddresses() != null).flatMap(subset -> subset.getAddresses().stream()).anyMatch(address -> Objects.equals(ip, address.getIp()))) {
                        return ObjectID.builder().name(metadata.getName()).namespace(metadata.getNamespace()).build();
                    }
                    return null;
                }).filter(Objects::nonNull).findFirst();
                if (!serviceID.isPresent()) {
                    log.debug("No corresponding endpoint for IP: {}", (Object)ip);
                    return config.serviceMetaInfoFactory().unknown();
                }
                Optional service = KubernetesServices.INSTANCE.findByID(serviceID.get());
                if (!service.isPresent()) {
                    log.debug("No service for namespace and name: {}", (Object)serviceID.get());
                    return config.serviceMetaInfoFactory().unknown();
                }
                log.debug("Composing service meta info from service and pod for IP: {}", (Object)ip);
                return K8SServiceRegistry.this.composeServiceMetaInfo((V1Service)service.get(), (V1Pod)pod.get());
            }
        });
    }

    protected List<ServiceMetaInfo.KeyValue> transformLabelsToTags(V1ObjectMeta podMeta) {
        Map labels = podMeta.getLabels();
        ArrayList<ServiceMetaInfo.KeyValue> tags = new ArrayList<ServiceMetaInfo.KeyValue>();
        tags.add(new ServiceMetaInfo.KeyValue("pod", podMeta.getName()));
        tags.add(new ServiceMetaInfo.KeyValue("namespace", podMeta.getNamespace()));
        if (Objects.isNull(labels)) {
            return tags;
        }
        return labels.entrySet().stream().map(each -> new ServiceMetaInfo.KeyValue((String)each.getKey(), (String)each.getValue())).collect(Collectors.toCollection(() -> tags));
    }

    public ServiceMetaInfo findService(String ip) {
        if (this.isNode(ip)) {
            return this.config.serviceMetaInfoFactory().unknown();
        }
        return (ServiceMetaInfo)this.ipServiceMetaInfoMap.get((Object)ip);
    }

    protected ServiceMetaInfo composeServiceMetaInfo(V1Service service, V1Pod pod) {
        ImmutableMap context = ImmutableMap.of((Object)"service", (Object)service, (Object)"pod", (Object)pod);
        ServiceMetaInfo serviceMetaInfo = new ServiceMetaInfo();
        V1ObjectMeta podMetadata = pod.getMetadata();
        try {
            serviceMetaInfo.setServiceName(this.serviceNameFormatter.format((Map<String, Object>)context));
        }
        catch (Exception e) {
            log.error("Failed to evaluate service name.", (Throwable)e);
            V1ObjectMeta serviceMetadata = service.getMetadata();
            if (Objects.isNull(serviceMetadata)) {
                log.warn("Service metadata is null, {}", (Object)service);
                return this.config.serviceMetaInfoFactory().unknown();
            }
            serviceMetaInfo.setServiceName(serviceMetadata.getName());
        }
        serviceMetaInfo.setServiceInstanceName(String.format("%s.%s", podMetadata.getName(), podMetadata.getNamespace()));
        serviceMetaInfo.setTags(this.transformLabelsToTags(podMetadata));
        return serviceMetaInfo;
    }

    public boolean isNode(String ip) {
        return ((Set)this.nodeIPs.get((Object)this)).contains(ip);
    }

    Tuple2<String, String> metadataID(V1ObjectMeta metadata) {
        return new Tuple2((Object)metadata.getNamespace(), (Object)metadata.getName());
    }
}

