/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.tcp.k8s;

import io.envoyproxy.envoy.config.core.v3.Address;
import io.envoyproxy.envoy.config.core.v3.SocketAddress;
import io.envoyproxy.envoy.data.accesslog.v3.AccessLogCommon;
import io.envoyproxy.envoy.data.accesslog.v3.TCPAccessLogEntry;
import io.envoyproxy.envoy.service.accesslog.v3.StreamAccessLogsMessage;
import lombok.Generated;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetrics;
import org.apache.skywalking.apm.network.servicemesh.v3.TCPServiceMeshMetric;
import org.apache.skywalking.apm.network.servicemesh.v3.TCPServiceMeshMetrics;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.AccessLogAnalyzer;
import org.apache.skywalking.oap.server.receiver.envoy.als.Role;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.apache.skywalking.oap.server.receiver.envoy.als.k8s.K8SServiceRegistry;
import org.apache.skywalking.oap.server.receiver.envoy.als.tcp.AbstractTCPAccessLogAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sALSServiceMeshTCPAnalysis
extends AbstractTCPAccessLogAnalyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8sALSServiceMeshTCPAnalysis.class);
    protected K8SServiceRegistry serviceRegistry;
    private EnvoyMetricReceiverConfig config;

    @Override
    public String name() {
        return "k8s-mesh";
    }

    @Override
    public void init(ModuleManager manager, EnvoyMetricReceiverConfig config) {
        this.config = config;
        this.serviceRegistry = new K8SServiceRegistry(config);
    }

    @Override
    public AccessLogAnalyzer.Result analysis(AccessLogAnalyzer.Result previousResult, StreamAccessLogsMessage.Identifier identifier, TCPAccessLogEntry entry, Role role) {
        if (previousResult.getMetrics() != null && previousResult.getMetrics().hasTcpMetrics()) {
            return previousResult;
        }
        switch (role) {
            case PROXY: {
                return this.analyzeProxy(previousResult, entry);
            }
            case SIDECAR: {
                return this.analyzeSideCar(previousResult, entry);
            }
        }
        return previousResult;
    }

    protected AccessLogAnalyzer.Result analyzeSideCar(AccessLogAnalyzer.Result previousResult, TCPAccessLogEntry entry) {
        AccessLogCommon properties = entry.getCommonProperties();
        if (properties == null) {
            return previousResult;
        }
        String cluster = properties.getUpstreamCluster();
        if (cluster == null) {
            return previousResult;
        }
        TCPServiceMeshMetrics.Builder sources = TCPServiceMeshMetrics.newBuilder();
        Address downstreamRemoteAddress = properties.hasDownstreamDirectRemoteAddress() ? properties.getDownstreamDirectRemoteAddress() : properties.getDownstreamRemoteAddress();
        ServiceMetaInfo downstreamService = this.find(downstreamRemoteAddress.getSocketAddress().getAddress());
        Address downstreamLocalAddress = properties.getDownstreamLocalAddress();
        ServiceMetaInfo localService = this.find(downstreamLocalAddress.getSocketAddress().getAddress());
        if (cluster.startsWith("inbound|")) {
            TCPServiceMeshMetric metrics;
            if (downstreamService.equals(this.config.serviceMetaInfoFactory().unknown())) {
                metrics = this.newAdapter(entry, null, localService).adaptToDownstreamMetrics().build();
                log.debug("Transformed ingress->sidecar inbound mesh metrics {}", (Object)metrics);
            } else {
                metrics = this.newAdapter(entry, downstreamService, localService).adaptToDownstreamMetrics().build();
                log.debug("Transformed sidecar->sidecar(server side) inbound mesh metrics {}", (Object)metrics);
            }
            sources.addMetrics(metrics);
        } else if (cluster.startsWith("outbound|")) {
            Address upstreamRemoteAddress = properties.getUpstreamRemoteAddress();
            ServiceMetaInfo destService = this.find(upstreamRemoteAddress.getSocketAddress().getAddress());
            TCPServiceMeshMetric metric = this.newAdapter(entry, downstreamService, destService).adaptToUpstreamMetrics().build();
            log.debug("Transformed sidecar->sidecar(server side) inbound mesh metric {}", (Object)metric);
            sources.addMetrics(metric);
        }
        return AccessLogAnalyzer.Result.builder().metrics(ServiceMeshMetrics.newBuilder().setTcpMetrics(sources)).service(localService).build();
    }

    protected AccessLogAnalyzer.Result analyzeProxy(AccessLogAnalyzer.Result previousResult, TCPAccessLogEntry entry) {
        AccessLogCommon properties = entry.getCommonProperties();
        if (properties == null) {
            return previousResult;
        }
        Address downstreamLocalAddress = properties.getDownstreamLocalAddress();
        Address downstreamRemoteAddress = properties.hasDownstreamDirectRemoteAddress() ? properties.getDownstreamDirectRemoteAddress() : properties.getDownstreamRemoteAddress();
        Address upstreamRemoteAddress = properties.getUpstreamRemoteAddress();
        if (downstreamLocalAddress == null || downstreamRemoteAddress == null || upstreamRemoteAddress == null) {
            return previousResult;
        }
        TCPServiceMeshMetrics.Builder metrics = TCPServiceMeshMetrics.newBuilder();
        SocketAddress downstreamRemoteAddressSocketAddress = downstreamRemoteAddress.getSocketAddress();
        ServiceMetaInfo outside = this.find(downstreamRemoteAddressSocketAddress.getAddress());
        SocketAddress downstreamLocalAddressSocketAddress = downstreamLocalAddress.getSocketAddress();
        ServiceMetaInfo ingress = this.find(downstreamLocalAddressSocketAddress.getAddress());
        TCPServiceMeshMetric.Builder metric = this.newAdapter(entry, outside, ingress).adaptToDownstreamMetrics();
        log.debug("Transformed ingress inbound mesh metric {}", (Object)metric);
        metrics.addMetrics(metric);
        SocketAddress upstreamRemoteAddressSocketAddress = upstreamRemoteAddress.getSocketAddress();
        ServiceMetaInfo targetService = this.find(upstreamRemoteAddressSocketAddress.getAddress());
        TCPServiceMeshMetric.Builder outboundMetric = this.newAdapter(entry, ingress, targetService).adaptToUpstreamMetrics().setTlsMode("NONE");
        log.debug("Transformed ingress outbound mesh metric {}", (Object)outboundMetric);
        metrics.addMetrics(outboundMetric);
        return AccessLogAnalyzer.Result.builder().metrics(ServiceMeshMetrics.newBuilder().setTcpMetrics(metrics)).service(ingress).build();
    }

    protected ServiceMetaInfo find(String ip) {
        return this.serviceRegistry.findService(ip);
    }
}

