/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.envoy.als.k8s;

import io.envoyproxy.envoy.config.core.v3.Address;
import io.envoyproxy.envoy.config.core.v3.SocketAddress;
import io.envoyproxy.envoy.data.accesslog.v3.AccessLogCommon;
import io.envoyproxy.envoy.data.accesslog.v3.HTTPAccessLogEntry;
import io.envoyproxy.envoy.service.accesslog.v3.StreamAccessLogsMessage;
import lombok.Generated;
import org.apache.skywalking.apm.network.servicemesh.v3.HTTPServiceMeshMetric;
import org.apache.skywalking.apm.network.servicemesh.v3.HTTPServiceMeshMetrics;
import org.apache.skywalking.apm.network.servicemesh.v3.ServiceMeshMetrics;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.apache.skywalking.oap.server.receiver.envoy.EnvoyMetricReceiverConfig;
import org.apache.skywalking.oap.server.receiver.envoy.als.AbstractALSAnalyzer;
import org.apache.skywalking.oap.server.receiver.envoy.als.AccessLogAnalyzer;
import org.apache.skywalking.oap.server.receiver.envoy.als.Role;
import org.apache.skywalking.oap.server.receiver.envoy.als.ServiceMetaInfo;
import org.apache.skywalking.oap.server.receiver.envoy.als.k8s.Addresses;
import org.apache.skywalking.oap.server.receiver.envoy.als.k8s.K8SServiceRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class K8sALSServiceMeshHTTPAnalysis
extends AbstractALSAnalyzer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(K8sALSServiceMeshHTTPAnalysis.class);
    protected K8SServiceRegistry serviceRegistry;
    protected EnvoyMetricReceiverConfig config;

    @Override
    public String name() {
        return "k8s-mesh";
    }

    @Override
    public void init(ModuleManager manager, EnvoyMetricReceiverConfig config) {
        this.config = config;
        this.serviceRegistry = new K8SServiceRegistry(config);
    }

    @Override
    public AccessLogAnalyzer.Result analysis(AccessLogAnalyzer.Result result, StreamAccessLogsMessage.Identifier identifier, HTTPAccessLogEntry entry, Role role) {
        if (result.hasResult()) {
            return result;
        }
        switch (role) {
            case PROXY: {
                return this.analyzeProxy(entry);
            }
            case SIDECAR: {
                return this.analyzeSideCar(entry);
            }
        }
        return AccessLogAnalyzer.Result.builder().build();
    }

    protected AccessLogAnalyzer.Result analyzeSideCar(HTTPAccessLogEntry entry) {
        if (!entry.hasCommonProperties()) {
            return AccessLogAnalyzer.Result.builder().build();
        }
        AccessLogCommon properties = entry.getCommonProperties();
        String cluster = properties.getUpstreamCluster();
        if (StringUtil.isBlank((String)cluster)) {
            return AccessLogAnalyzer.Result.builder().build();
        }
        HTTPServiceMeshMetrics.Builder sources = HTTPServiceMeshMetrics.newBuilder();
        Address downstreamRemoteAddress = properties.hasDownstreamDirectRemoteAddress() ? properties.getDownstreamDirectRemoteAddress() : properties.getDownstreamRemoteAddress();
        ServiceMetaInfo downstreamService = this.find(downstreamRemoteAddress.getSocketAddress().getAddress());
        Address downstreamLocalAddress = properties.getDownstreamLocalAddress();
        if (!Addresses.isValid(downstreamRemoteAddress) || !Addresses.isValid(downstreamLocalAddress)) {
            return AccessLogAnalyzer.Result.builder().build();
        }
        ServiceMetaInfo localService = this.find(downstreamLocalAddress.getSocketAddress().getAddress());
        if (cluster.startsWith("inbound|")) {
            HTTPServiceMeshMetric.Builder metrics;
            if (downstreamService.equals(this.config.serviceMetaInfoFactory().unknown())) {
                metrics = this.newAdapter(entry, null, localService).adaptToDownstreamMetrics();
                log.debug("Transformed ingress->sidecar inbound mesh metrics {}", (Object)metrics);
            } else {
                metrics = this.newAdapter(entry, downstreamService, localService).adaptToDownstreamMetrics();
                log.debug("Transformed sidecar->sidecar(server side) inbound mesh metrics {}", (Object)metrics);
            }
            sources.addMetrics(metrics);
        } else if (cluster.startsWith("outbound|")) {
            Address upstreamRemoteAddress = properties.getUpstreamRemoteAddress();
            if (!Addresses.isValid(upstreamRemoteAddress)) {
                return AccessLogAnalyzer.Result.builder().metrics(ServiceMeshMetrics.newBuilder().setHttpMetrics(sources)).service(localService).build();
            }
            ServiceMetaInfo destService = this.find(upstreamRemoteAddress.getSocketAddress().getAddress());
            HTTPServiceMeshMetric.Builder metric = this.newAdapter(entry, downstreamService, destService).adaptToUpstreamMetrics();
            log.debug("Transformed sidecar->sidecar(server side) inbound mesh metric {}", (Object)metric);
            sources.addMetrics(metric);
        }
        return AccessLogAnalyzer.Result.builder().metrics(ServiceMeshMetrics.newBuilder().setHttpMetrics(sources)).service(localService).build();
    }

    protected AccessLogAnalyzer.Result analyzeProxy(HTTPAccessLogEntry entry) {
        if (!entry.hasCommonProperties()) {
            return AccessLogAnalyzer.Result.builder().build();
        }
        AccessLogCommon properties = entry.getCommonProperties();
        Address downstreamLocalAddress = properties.getDownstreamLocalAddress();
        Address downstreamRemoteAddress = properties.hasDownstreamDirectRemoteAddress() ? properties.getDownstreamDirectRemoteAddress() : properties.getDownstreamRemoteAddress();
        Address upstreamRemoteAddress = properties.getUpstreamRemoteAddress();
        if (!(Addresses.isValid(downstreamLocalAddress) && Addresses.isValid(downstreamRemoteAddress) && Addresses.isValid(upstreamRemoteAddress))) {
            return AccessLogAnalyzer.Result.builder().build();
        }
        HTTPServiceMeshMetrics.Builder result = HTTPServiceMeshMetrics.newBuilder();
        SocketAddress downstreamRemoteAddressSocketAddress = downstreamRemoteAddress.getSocketAddress();
        ServiceMetaInfo outside = this.find(downstreamRemoteAddressSocketAddress.getAddress());
        SocketAddress downstreamLocalAddressSocketAddress = downstreamLocalAddress.getSocketAddress();
        ServiceMetaInfo ingress = this.find(downstreamLocalAddressSocketAddress.getAddress());
        HTTPServiceMeshMetric.Builder metric = this.newAdapter(entry, outside, ingress).adaptToDownstreamMetrics();
        log.debug("Transformed ingress inbound mesh metric {}", (Object)metric);
        result.addMetrics(metric);
        SocketAddress upstreamRemoteAddressSocketAddress = upstreamRemoteAddress.getSocketAddress();
        ServiceMetaInfo targetService = this.find(upstreamRemoteAddressSocketAddress.getAddress());
        HTTPServiceMeshMetric.Builder outboundMetric = this.newAdapter(entry, ingress, targetService).adaptToUpstreamMetrics().setTlsMode("NONE");
        log.debug("Transformed ingress outbound mesh metric {}", (Object)outboundMetric);
        result.addMetrics(outboundMetric);
        return AccessLogAnalyzer.Result.builder().metrics(ServiceMeshMetrics.newBuilder().setHttpMetrics(result)).service(ingress).build();
    }

    protected ServiceMetaInfo find(String ip) {
        return this.serviceRegistry.findService(ip);
    }
}

