/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oal.tool;

import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.apache.skywalking.apm.util.StringUtil;
import org.apache.skywalking.oal.tool.meta.MetaReader;
import org.apache.skywalking.oal.tool.meta.MetaSettings;
import org.apache.skywalking.oal.tool.output.FileGenerator;
import org.apache.skywalking.oal.tool.parser.MetricsHolder;
import org.apache.skywalking.oal.tool.parser.OALScripts;
import org.apache.skywalking.oal.tool.parser.ScriptParser;
import org.apache.skywalking.oal.tool.parser.SourceColumnsFactory;
import org.apache.skywalking.oap.server.core.annotation.AnnotationListener;
import org.apache.skywalking.oap.server.core.annotation.AnnotationScan;
import org.apache.skywalking.oap.server.core.source.DefaultScopeDefine;

public class Main {
    public static void main(String[] args) throws IOException, TemplateException {
        AnnotationScan scopeScan = new AnnotationScan();
        scopeScan.registerListener((AnnotationListener)new DefaultScopeDefine.Listener());
        scopeScan.scan(null);
        String modulePath = args[0];
        String scriptFilePath = StringUtil.join((char)File.separatorChar, (String[])new String[]{modulePath, "src", "main", "resources", "official_analysis.oal"});
        String outputPath = StringUtil.join((char)File.separatorChar, (String[])new String[]{modulePath, "..", "generated-analysis", "target", "generated-sources", "oal", "org", "apache", "skywalking", "oap", "server", "core", "analysis"});
        String metaFilePath = StringUtil.join((char)File.separatorChar, (String[])new String[]{modulePath, "src", "main", "resources", "generator-scope-meta.yml"});
        MetricsHolder.init();
        File scriptFile = new File(scriptFilePath);
        if (!scriptFile.exists()) {
            throw new IllegalArgumentException("OAL script file [" + scriptFilePath + "] doesn't exist");
        }
        File metaFile = new File(metaFilePath);
        if (!metaFile.exists()) {
            throw new IllegalArgumentException("Generator meta file [" + metaFilePath + "] doesn't exist");
        }
        MetaReader reader = new MetaReader();
        MetaSettings metaSettings = reader.read(new FileInputStream(metaFile));
        SourceColumnsFactory.setSettings(metaSettings);
        ScriptParser scriptParser = ScriptParser.createFromFile(scriptFilePath);
        OALScripts oalScripts = scriptParser.parse();
        FileGenerator generator = new FileGenerator(oalScripts, outputPath);
        generator.generate();
    }
}

